/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlruntime;

import java.util.HashSet;
import java.util.Set;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.xmlparser.Namespace;
import oracle.bpm.xmlruntime.XMLObject;

public class SerializationContext {
    private Set<String> namespaceDeclaration;
    private XMLObject.NSMap nspaces;
    private IndentedPrintWriter out;

    public SerializationContext(SerializationContext parent) {
        this.namespaceDeclaration = new HashSet<String>();
        this.nspaces = new XMLObject.NSMap(parent.getNSMap());
        this.out = parent.getOutput();
    }

    public SerializationContext(IndentedPrintWriter out, XMLObject.NSMap nspaces, Set<String> namespaceDeclaration) {
        this.out = out;
        this.nspaces = nspaces;
        this.namespaceDeclaration = namespaceDeclaration;
    }

    public IndentedPrintWriter getOutput() {
        return this.out;
    }

    public XMLObject.NSMap getNSMap() {
        return this.nspaces;
    }

    public Set<String> getNamespaceDeclaration() {
        return this.namespaceDeclaration;
    }

    public void addNamespaceToNamespaceDeclaration(String prefix, Namespace namespace) {
        if (namespace != null) {
            String namespaceDefinition = " xmlns:" + prefix + "=\"" + namespace.getUri() + "\" ";
            Set<String> namespaceDeclarations = this.getNamespaceDeclaration();
            boolean isDefined = namespaceDeclarations.contains(namespaceDefinition);
            if (!isDefined) {
                namespaceDeclarations.add(namespaceDefinition);
            }
        }
    }
}

