/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlgen;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.JavaClassGenerator;
import oracle.bpm.xmlgen.BaseGenerator;
import oracle.bpm.xmlgen.XmlClassGenerator;
import oracle.bpm.xmlgen.XmlConfiguration;
import oracle.bpm.xmlgen.XmlEnumGenerator;

public class XmlBeanGenerator
extends BaseGenerator {
    private Map<String, TypeDescription> elements;

    protected XmlBeanGenerator(XmlConfiguration config, Map<String, TypeDescription> elements) {
        super(config);
        this.elements = elements;
    }

    void generateBean(ObjectTypeDescription type) throws Exception {
        File file;
        JavaClassGenerator generator;
        HashSet<String> elementNames = new HashSet<String>();
        for (Map.Entry<String, TypeDescription> entry : this.elements.entrySet()) {
            if (entry.getValue() != type) continue;
            elementNames.add(entry.getKey());
        }
        boolean generateBaseClasses = this.isGenerateBaseClasses() && !type.isEnum();
        IndentedPrintWriter out = this.openClass((generateBaseClasses ? "Base" : "") + type.getName());
        if (type.isEnum()) {
            generator = new XmlEnumGenerator(this.getConfig());
        } else {
            XmlClassGenerator xml = new XmlClassGenerator(this.getConfig());
            xml.setElementNames(elementNames);
            generator = xml;
        }
        generator.setJavaPackage(this.getJavaPackage());
        generator.generate(out, type);
        out.close();
        if (generateBaseClasses && !(file = this.openBeanFile(type.getName())).exists()) {
            out = this.openBean(type.getName());
            out.println("package " + this.getJavaPackage() + ";");
            out.println();
            out.println("public class " + this.getPrefix() + type.getName());
            out.println("    extends " + this.getPrefix() + "Base" + type.getName());
            out.println("{");
            out.println("}");
            out.close();
        }
    }
}

