/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.wfmc.parser;

import java.util.Locale;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;

public enum BasicDataType implements I18nProvider
{
    STRING(ProjectMsg.STRING),
    FLOAT(ProjectMsg.FLOAT),
    INTEGER(ProjectMsg.INTEGER),
    REFERENCE(ProjectMsg.REFERENCE),
    DATETIME(ProjectMsg.DATETIME),
    BOOLEAN(ProjectMsg.BOOLEAN),
    PERFORMER(ProjectMsg.PERFORMER);

    private transient Msg msg;

    private BasicDataType(Msg msg) {
        this.msg = msg;
    }

    public static BasicDataType valueOf(int n) {
        return BasicDataType.values()[n];
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public TypeDescription toFuegoType() {
        if (this == STRING) {
            return TypeFactory.getString();
        }
        if (this == FLOAT) {
            return TypeFactory.getReal();
        }
        if (this == INTEGER) {
            return TypeFactory.getInt();
        }
        if (this == BOOLEAN) {
            return TypeFactory.getBool();
        }
        if (this == DATETIME) {
            return TypeFactory.getTime();
        }
        return TypeFactory.getAny();
    }

    public Msg getMsg() {
        return this.msg;
    }
}

