/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.aris.parser;

import java.util.Arrays;

class ElementType {
    static final int AML = 0;
    static final int ATTR_DEF = 1;
    static final int ATTR_OCC = 2;
    static final int ATTR_VALUE = 3;
    static final int BRUSH = 4;
    static final int CXN_DEF = 5;
    static final int CXN_OCC = 6;
    static final int DATABASE = 7;
    static final int EXTCXNDEF = 8;
    static final int FF_TEXT_DEF = 9;
    static final int FF_TEXT_OCC = 10;
    static final int FILTER_GUID = 11;
    static final int FLAG = 12;
    static final int FONT_NODE = 13;
    static final int FONT_STYLE_SHEET = 14;
    static final int GUID = 15;
    static final int GROUP = 16;
    static final int HEADER_INFO = 17;
    static final int LANE = 18;
    static final int LANGUAGE = 19;
    static final int LANGUAGE_NAME = 20;
    static final int LOG_FONT = 21;
    static final int MASTER_GUID = 22;
    static final int MODEL = 23;
    static final int OBJ_DEF = 24;
    static final int OBJ_OCC = 25;
    static final int PEN = 26;
    static final int POSITION = 27;
    static final int PREFIX = 28;
    static final int SIZE = 29;
    static final int SYMBOL_GUID = 30;
    static final int USER = 31;
    static final int USER_GROUP = 32;
    private static int LAST = 32;
    private static String[] names = new String[LAST + 1];

    ElementType() {
    }

    static int findByName(String name) {
        return Arrays.binarySearch(names, name);
    }

    static String findByType(int type) {
        return type >= 0 && type < names.length ? names[type] : null;
    }

    static {
        ElementType.names[0] = "AML";
        ElementType.names[1] = "AttrDef";
        ElementType.names[2] = "AttrOcc";
        ElementType.names[3] = "AttrValue";
        ElementType.names[4] = "Brush";
        ElementType.names[5] = "CxnDef";
        ElementType.names[6] = "CxnOcc";
        ElementType.names[7] = "Database";
        ElementType.names[8] = "ExtCxnDef";
        ElementType.names[15] = "GUID";
        ElementType.names[16] = "Group";
        ElementType.names[11] = "FilterGUID";
        ElementType.names[12] = "Flag";
        ElementType.names[9] = "FFTextDef";
        ElementType.names[10] = "FFTextOcc";
        ElementType.names[13] = "FontNode";
        ElementType.names[14] = "FontStyleSheet";
        ElementType.names[17] = "Header-Info";
        ElementType.names[19] = "Language";
        ElementType.names[18] = "Lane";
        ElementType.names[20] = "LanguageName";
        ElementType.names[21] = "LogFont";
        ElementType.names[22] = "MasterGUID";
        ElementType.names[23] = "Model";
        ElementType.names[24] = "ObjDef";
        ElementType.names[25] = "ObjOcc";
        ElementType.names[26] = "Pen";
        ElementType.names[27] = "Position";
        ElementType.names[28] = "Prefix";
        ElementType.names[29] = "Size";
        ElementType.names[30] = "SymbolGUID";
        ElementType.names[31] = "User";
        ElementType.names[32] = "UserGroup";
        for (int i = 1; i < names.length; ++i) {
            if (names[i - 1].compareTo(names[i]) <= 1) continue;
            throw new RuntimeException("Names must be sorted by name: " + names[i - 1] + " > " + names[i]);
        }
    }
}

