/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.aris.parser;

import java.util.LinkedHashSet;
import java.util.Set;
import oracle.bpm.xmlparser.DefaultElement;

public abstract class ArisElement
extends DefaultElement {
    public abstract String getId();

    public boolean containsAttribute(String attribute) {
        return this.getAttribute(attribute) != null;
    }

    public Set findAllDescendantsByClass(ArisElement root, Class cl) {
        return this.findAllDescendantsByClass(root, cl, null);
    }

    public Set findAllDescendantsByClass(ArisElement current, Class cl, Class filter) {
        LinkedHashSet resultSet = new LinkedHashSet();
        this.findDescendantByClass(current, resultSet, cl, filter);
        return resultSet;
    }

    public ArisElement findChildByAttributeValueInAll(ArisElement current, String attribute, String value) {
        return this.findChildByAttributeValueInAll(current, attribute, value, null);
    }

    public ArisElement findChildByAttributeValueInAll(ArisElement current, String attribute, String value, Class filter) {
        DefaultElement found = current.findChildByAttributeValue(attribute, value);
        if (found != null) {
            return (ArisElement)found;
        }
        if (filter != null) {
            ArisElement[] children = (ArisElement[])current.findChildrenByClass(filter);
            for (int i = 0; i < children.length && (found = this.findChildByAttributeValueInAll(children[i], attribute, value, filter)) == null; ++i) {
            }
        } else {
            for (DefaultElement child = current.getFirstElement(); child != null && (found = this.findChildByAttributeValueInAll((ArisElement)child, attribute, value, filter)) == null; child = child.getNextElement()) {
            }
        }
        return (ArisElement)found;
    }

    public Set findChildrenByClassAsSet(Class cl) {
        LinkedHashSet<DefaultElement> children = new LinkedHashSet<DefaultElement>();
        for (DefaultElement current = this.getFirstElement(); current != null; current = current.getNextElement()) {
            if (!cl.isAssignableFrom(current.getClass())) continue;
            children.add(current);
        }
        return children;
    }

    protected String getAttrDefValue(String attribute, String value) {
        DefaultElement attrDef = this.findChildByAttributeValue(attribute, value);
        if (attrDef == null) {
            return null;
        }
        DefaultElement attrValue = attrDef.getFirstElement();
        DefaultElement textElem = attrValue.getFirstElement();
        return textElem.toString();
    }

    protected boolean hasNextElement() {
        return this.getNextElement() != null;
    }

    private void findDescendantByClass(ArisElement current, Set resultSet, Class cl, Class filter) {
        ArisElement[] children = (ArisElement[])current.findChildrenByClass(cl);
        for (int i = 0; i < children.length; ++i) {
            resultSet.add(children[i]);
        }
        if (filter != null) {
            ArisElement[] parents = (ArisElement[])current.findChildrenByClass(filter);
            for (int i = 0; i < parents.length; ++i) {
                this.findDescendantByClass(parents[i], resultSet, cl, filter);
            }
        } else {
            for (ArisElement element = (ArisElement)current.getFirstElement(); element != null; element = (ArisElement)element.getNextElement()) {
                this.findDescendantByClass(element, resultSet, cl, filter);
            }
        }
    }
}

