/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer;

import java.util.Iterator;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.processmodel.ActivityType;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;

public final class ImportRuleActivity {
    private final Msg msg;
    private final String name;
    private final ActivityType type;
    public static final ImportRuleActivity SKIP_SHAPE = new ImportRuleActivity("SKIP_SHAPE", ProjectMsg.SKIP_SHAPE);
    public static final ImportRuleActivity NOT_DEFINED = new ImportRuleActivity("NOT_DEFINED", ProjectMsg.NOT_DEFINED_RULE);
    public static final ImportRuleActivity ROLE = new ImportRuleActivity("ROLE", ProjectMsg.ROLE);
    public static final ImportRuleActivity NOTE = new ImportRuleActivity("NOTE", ProjectMsg.NOTE);
    private static SortedStringMap<ImportRuleActivity> activityFromExternalName;

    public ImportRuleActivity(ActivityType type) {
        this.name = type.toString();
        this.type = type;
        this.msg = null;
    }

    private ImportRuleActivity(String name, Msg msg) {
        this.name = name;
        this.type = null;
        this.msg = msg;
    }

    public static ComboBox createCombo(UiContainer parent) {
        ComboBox activityTypeComboBox = UiFactory.createComboBox((UiContainer)parent);
        Iterator i$ = ImportRuleActivity.getActivityTypes().keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String displayName = o = (String)i$.next();
            activityTypeComboBox.addItem((Object)displayName);
        }
        return activityTypeComboBox;
    }

    public static ImportRuleActivity createFromExternal(String displayName) {
        return (ImportRuleActivity)ImportRuleActivity.getActivityTypes().get(displayName);
    }

    public static SortedStringMap<ImportRuleActivity> getActivityTypes() {
        if (activityFromExternalName == null) {
            ImportRuleActivity.initActivityFromExternalName();
        }
        return activityFromExternalName;
    }

    public static ImportRuleActivity valueOf(String name) {
        ActivityType type = ActivityType.valueOf(name);
        if (type != null) {
            if (type.equals(ActivityType.BEGIN) || type.equals(ActivityType.END)) {
                type = ActivityType.AUTOMATIC;
            }
            return new ImportRuleActivity(type);
        }
        if (ImportRuleActivity.SKIP_SHAPE.name.equals(name)) {
            return SKIP_SHAPE;
        }
        if (ImportRuleActivity.NOT_DEFINED.name.equals(name)) {
            return NOT_DEFINED;
        }
        if (ImportRuleActivity.ROLE.name.equals(name)) {
            return ROLE;
        }
        if (ImportRuleActivity.NOTE.name.equals(name)) {
            return NOTE;
        }
        return null;
    }

    public Msg getMsg() {
        return this.type != null ? this.type.getMsg() : this.msg;
    }

    public String getString() {
        if (this.type != null) {
            return this.type.getString();
        }
        return this.msg.getString();
    }

    public ActivityType getType() {
        return this.type;
    }

    public boolean isNote() {
        return this == NOTE;
    }

    public boolean isRole() {
        return this == ROLE;
    }

    public boolean isSkip() {
        return this == SKIP_SHAPE;
    }

    public String toString() {
        return this.name;
    }

    private static void initActivityFromExternalName() {
        ActivityType[] activities;
        activityFromExternalName = SortedStringMap.create();
        for (ActivityType activity : activities = new ActivityType[]{ActivityType.GLOBAL_CREATION, ActivityType.GLOBAL_AUTOMATIC, ActivityType.GLOBAL, ActivityType.INTERACTIVE, ActivityType.AUTOMATIC, ActivityType.OR_SPLIT, ActivityType.SPLIT, ActivityType.SPLIT_N, ActivityType.JOIN, ActivityType.GRAB, ActivityType.SUBFLOW, ActivityType.PROCESS_CREATION, ActivityType.TERMINATION_WAIT, ActivityType.NOTIFICATION_WAIT, ActivityType.PROCESS_NOTIFICATION, ActivityType.COMPENSATE, ActivityType.CONDITIONAL}) {
            ImportRuleActivity.putImportRuleActivity(activity);
        }
        ImportRuleActivity.putImportRuleActivity(SKIP_SHAPE);
        ImportRuleActivity.putImportRuleActivity(ROLE);
        ImportRuleActivity.putImportRuleActivity(NOTE);
    }

    private static void putImportRuleActivity(ActivityType actType) {
        ImportRuleActivity.putImportRuleActivity(new ImportRuleActivity(actType));
    }

    private static void putImportRuleActivity(ImportRuleActivity importRuleActivity) {
        activityFromExternalName.put(importRuleActivity.getString(), importRuleActivity);
    }
}

