/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.msg;

import java.util.Date;
import java.util.Locale;
import oracle.bpm.lang.Time;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.history.model.ChangedItem;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FriendlyDateFormat;

public class HistoryMsgHelper {
    public static String getChangeTitle(Change change, Locale locale) {
        String result = null;
        if (change.getHistoryProjectMetadata().isInitialChange()) {
            result = MetadataMsg.CHANGE_TITLE_CREATION.getString(locale);
        } else {
            int counter = 0;
            String artifactName = null;
            String actionName = null;
            for (ChangedItem changedItem : change.getChangedItems()) {
                switch (changedItem.getType()) {
                    case BPMN: {
                        result = null;
                    }
                    case BUSINESS_RULE: 
                    case HUMAN_TASK: 
                    case FORM: 
                    case BPEL: {
                        if (result == null) {
                            artifactName = changedItem.getName();
                            actionName = changedItem.getChangeAction().getLabel(locale);
                        }
                        ++counter;
                        break;
                    }
                }
            }
            if (counter == 0) {
                result = MetadataMsg.CHANGE_TITLE_RESOURCE.getString(locale);
            } else {
                Msg msg = counter > 1 ? MetadataMsg.CHANGE_TITLE_MULTIPLE(actionName, artifactName) : MetadataMsg.CHANGE_TITLE(actionName, artifactName);
                result = msg.getString(locale);
            }
        }
        return result;
    }

    public static String getChangeSubtitle(Change change, Locale locale) {
        Date date = change.getChangeDate();
        String author = change.getAuthor();
        String time = FriendlyDateFormat.format(Time.valueOf(date), 1, locale);
        return MetadataMsg.CHANGE_SUBTITLE(time, author).getString(locale);
    }

    public static String getChangeItemTitle(ChangedItem change, Locale locale) {
        return change.getName();
    }
}

