/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import oracle.bpm.metadata.history.model.ChangePK;
import oracle.bpm.metadata.history.model.ChangedFile;
import oracle.bpm.metadata.history.model.ChangedItem;
import oracle.bpm.metadata.history.model.HistoryProjectMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@IdClass(value=ChangePK.class)
@Table(name="BPM_PML_HS")
public class Change
implements Serializable {
    @Id
    private String author;
    @Column(name="CHANGE_DATE")
    @Id
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date changeDate;
    @OneToMany(cascade={CascadeType.ALL})
    private List<ChangedItem> changedItems;
    @Column(name="CHANGES")
    @Lob
    private List<ChangedFile> filesChanged;
    @Column(name="METADATA_CHANGE")
    @Lob
    private HistoryProjectMetadata historyProjectMetadata;
    @Id
    private String projectName;
    private String projectType;
    private static final long serialVersionUID = 1875211792195269936L;

    public Change() {
    }

    public Change(@NotNull String author, @Nullable List<ChangedFile> filesChanged, @NotNull String projectId, @NotNull Date changeDate, @Nullable List<ChangedItem> changedItems, @Nullable HistoryProjectMetadata historyProjectMetadata, @NotNull String projectType) {
        if (author == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/model/Change.<init> must not be null");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/history/model/Change.<init> must not be null");
        }
        if (changeDate == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/history/model/Change.<init> must not be null");
        }
        if (projectType == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of oracle/bpm/metadata/history/model/Change.<init> must not be null");
        }
        this.author = author;
        this.filesChanged = filesChanged;
        this.projectName = projectId;
        this.changeDate = changeDate;
        this.changedItems = changedItems;
        this.historyProjectMetadata = historyProjectMetadata;
        this.projectType = projectType;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getProjectId() {
        return this.projectName;
    }

    public String getProjectName() {
        String[] split = this.getProjectId().split("/");
        assert (split.length > 0);
        return split[split.length - 1];
    }

    public List<ChangedFile> getFilesChanged() {
        return this.filesChanged;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public List<ChangedItem> getChangedItems() {
        return this.changedItems;
    }

    public HistoryProjectMetadata getHistoryProjectMetadata() {
        return this.historyProjectMetadata;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public boolean equals(Object o) {
        Change changeO;
        return o instanceof Change && this.author.equals((changeO = (Change)o).getAuthor()) && this.changeDate.equals(changeO.getChangeDate()) && ((Object)this.filesChanged).equals(changeO.getFilesChanged()) && this.projectName.equals(changeO.getProjectId()) && ((Object)this.changedItems).equals(changeO.getChangedItems());
    }
}

