/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.exception;

import oracle.bpm.metadata.exception.AuthenticationException;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectAlreadyExistsException;
import oracle.bpm.metadata.exception.ProjectLockedException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.msg.MetadataMsg;
import org.jetbrains.annotations.NotNull;

public final class MetadataExceptionFactory {
    private MetadataExceptionFactory() {
    }

    public static MetadataException createProjectNotFound(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProjectNotFound must not be null");
        }
        return new ProjectNotFoundException(MetadataMsg.PROJECT_NOT_FOUND(projectName));
    }

    public static MetadataException createProcessNotFoundException(@NotNull String processName) {
        if (processName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProcessNotFoundException must not be null");
        }
        return new MetadataException(MetadataMsg.PROCESS_NOT_FOUND(processName));
    }

    public static MetadataException createInvalidProjectException() {
        return new MetadataException(MetadataMsg.INVALID_PROJECT);
    }

    public static MetadataException createProjectLockedException(@NotNull String username, @NotNull String applicationName) {
        if (username == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProjectLockedException must not be null");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProjectLockedException must not be null");
        }
        return new ProjectLockedException(username, applicationName);
    }

    public static MetadataException createUserAuthenticationException(@NotNull Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createUserAuthenticationException must not be null");
        }
        return new AuthenticationException(MetadataMsg.USER_AUTHENTICATION_ERROR, exception);
    }

    public static MetadataException createProjectAlreadyExists(@NotNull String projectName, @NotNull String path) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProjectAlreadyExists must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProjectAlreadyExists must not be null");
        }
        return new MetadataException(MetadataMsg.PROJECT_ALREADY_EXISTS(projectName, path));
    }

    public static MetadataException createProjectIsNotTemplate() {
        return new MetadataException(MetadataMsg.PROJECT_IS_NOT_TEMPLATE);
    }

    public static MetadataException createOwnerNotSet() {
        return new MetadataException(MetadataMsg.OWNER_NOT_SET);
    }

    public static MetadataException createUnableToUpdateFromBaseTemplate(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createUnableToUpdateFromBaseTemplate must not be null");
        }
        return new MetadataException(MetadataMsg.UNABLE_TO_UPDATE_FROM_BASE_TEMPLATE(projectName));
    }

    public static MetadataException createUnableToDeleteTemplate(@NotNull String templateName, @NotNull String linkedProjectsNames) {
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createUnableToDeleteTemplate must not be null");
        }
        if (linkedProjectsNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createUnableToDeleteTemplate must not be null");
        }
        return new MetadataException(MetadataMsg.UNABLE_TO_DELETE_TEMPLATE(templateName, linkedProjectsNames));
    }

    public static ProjectAlreadyExistsException createProjectAlreadyExists(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createProjectAlreadyExists must not be null");
        }
        return new ProjectAlreadyExistsException(MetadataMsg.STUDIO_PROJECT_ALREADY_EXISTS(projectName));
    }

    public static MetadataException createProjectIsNotPublicShare() {
        return new MetadataException(MetadataMsg.PROJECT_IS_NOT_PUBLIC_SHARE);
    }

    public static MetadataException createArtifactAlreadyExists(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/exception/MetadataExceptionFactory.createArtifactAlreadyExists must not be null");
        }
        return new MetadataException(MetadataMsg.ARTIFACT_ALREADY_EXISTS(projectName));
    }
}

