/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.mmp;

import fuego.rmi.mmp.SocketConnection;
import fuego.rmi.mmp.SocketListener;
import fuego.rmi.spi.ConnectException;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.ListenException;
import fuego.rmi.spi.Listener;
import fuego.rmi.spi.Transport;
import fuego.rmi.spi.TransportException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import oracle.bpm.util.NetURL;

abstract class SocketTransport
implements Transport {
    private volatile boolean initialized = false;

    SocketTransport() {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public Connection connect(NetURL url) throws TransportException {
        Socket sock;
        try {
            this.doInitialize();
        }
        catch (Exception e) {
            throw new ConnectException(url.toString(), (Throwable)e);
        }
        try {
            InetAddress addr = InetAddress.getByName(url.getHost());
            int port = url.getPort();
            sock = this.createSocket(addr, port);
        }
        catch (IOException ex) {
            throw new ConnectException(url.getHost() + ":" + url.getPort(), (Throwable)ex);
        }
        return new SocketConnection(sock);
    }

    @Override
    public Listener createListener(NetURL url) throws TransportException {
        ServerSocket sock;
        try {
            this.doInitialize();
        }
        catch (Exception e) {
            throw new ListenException(e);
        }
        try {
            InetAddress addr = InetAddress.getByName(url.getHost());
            int port = url.getPort();
            sock = this.createServerSocket(addr, port);
        }
        catch (IOException ex) {
            throw new ListenException(ex);
        }
        url = NetURL.create(url.toString());
        url.setPort(sock.getLocalPort());
        return new SocketListener(sock, url);
    }

    protected abstract ServerSocket createServerSocket(InetAddress var1, int var2) throws IOException;

    protected abstract Socket createSocket(InetAddress var1, int var2) throws IOException;

    protected void initialize() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialize() throws Exception {
        SocketTransport socketTransport = this;
        synchronized (socketTransport) {
            if (this.initialized) {
                return;
            }
            this.initialize();
            this.initialized = true;
        }
    }
}

