/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi.mmp;

import fuego.rmi.mmp.SocketConnection;
import fuego.rmi.spi.Connection;
import fuego.rmi.spi.DismissException;
import fuego.rmi.spi.ListenException;
import fuego.rmi.spi.Listener;
import fuego.rmi.spi.TransportException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import oracle.bpm.util.NetURL;

class SocketListener
implements Listener {
    private volatile boolean dismissed = false;
    private ServerSocket sock;
    private NetURL url;

    SocketListener(ServerSocket sock, NetURL url) {
        this.sock = sock;
        this.url = url;
    }

    @Override
    public NetURL getURL() throws TransportException {
        return this.url;
    }

    @Override
    public void dismiss() throws TransportException {
        try {
            this.dismissed = true;
            this.sock.close();
        }
        catch (IOException ex) {
            throw new DismissException(ex);
        }
    }

    @Override
    public Connection waitForConnection() throws TransportException {
        try {
            Socket s = this.sock.accept();
            return new SocketConnection(s);
        }
        catch (IOException e) {
            if (this.dismissed) {
                return null;
            }
            throw new ListenException(e);
        }
    }
}

