/*
 * Decompiled with CFR 0.152.
 */
package fuego.rmi;

import fuego.rmi.Channel;
import fuego.rmi.ChannelListener;
import fuego.rmi.Packet;
import fuego.rmi.RMIException;
import fuego.rmi.ServerCluster;
import fuego.rmi.spi.SendException;
import fuego.rmi.spi.TransportException;
import java.io.IOException;

public class RemoteChannelListener
implements ChannelListener {
    private ServerCluster group;
    private Integer proxyId;
    private boolean released;
    private Channel source;

    public RemoteChannelListener(Integer proxyId, ServerCluster group, Channel source) {
        this.proxyId = proxyId;
        this.group = group;
        this.source = source;
    }

    @Override
    public synchronized void dismiss(Channel c) {
        try {
            this.source.unregister(this);
            if (this.released) {
                return;
            }
            this.group.send(Packet.createDismiss(this.proxyId));
        }
        catch (RMIException rMIException) {
            // empty catch block
        }
    }

    @Override
    public void handleException(Throwable ex) {
    }

    @Override
    public synchronized void processMessage(Object message) throws RMIException {
        try {
            if (this.released) {
                throw new SendException(new IOException("channel closed"));
            }
            this.group.send(Packet.createNotification(this.proxyId, message));
        }
        catch (TransportException ex) {
            this.source.unregister(this);
            throw ex;
        }
    }

    synchronized void release() {
        this.released = true;
    }
}

