/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.features.CustomizedImageFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Lane;

public class SwitchLaneCommand
extends ProjectCommand {
    private int backgroundColor;
    private String customImageId;
    private Lane lane;
    private String newRole;
    private int oldBackgroundColor;
    private String oldImage;
    private String oldRole;

    public SwitchLaneCommand(Lane lane, String newRole, int backgroundColor) {
        this(lane, newRole, backgroundColor, null);
    }

    public SwitchLaneCommand(Lane lane, String newRole, int backgroundColor, String customImageId) {
        super(new ProjectObject[0]);
        this.lane = lane;
        this.newRole = newRole;
        this.backgroundColor = backgroundColor;
        this.customImageId = customImageId;
        CustomizedImageFeature imageFeature = lane.getFeature(CustomizedImageFeature.class);
        this.oldImage = imageFeature != null ? imageFeature.getValue() : null;
        this.oldRole = lane.getRole();
        this.oldBackgroundColor = lane.getBackgroundColor();
    }

    @Override
    public ProjectObject getAffectedObject() {
        return this.lane;
    }

    @Override
    public String getName() {
        return ProjectModelMsg.EDIT_LANE.getString();
    }

    @Override
    public Object execute() throws ExecutionException {
        this.lane.setRole(this.newRole);
        this.lane.setBackgroundColor(this.backgroundColor);
        this.setFeature(this.customImageId);
        return null;
    }

    @Override
    public void undo() {
        this.lane.setRole(this.oldRole);
        this.lane.setBackgroundColor(this.oldBackgroundColor);
        this.setFeature(this.oldImage);
    }

    private void setFeature(String customImageId) {
        this.lane.getFeature(CustomizedImageFeature.class).setValue(customImageId);
    }
}

