/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.collections.Sequence;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.RemoveMeasurementCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class RemoveTransitionCommand
extends MultipleCommand {
    private SequenceFlow sequenceFlow;

    public RemoveTransitionCommand(@NotNull SequenceFlow sequenceFlow) {
        super(sequenceFlow);
        this.sequenceFlow = sequenceFlow;
        this.buildMultipleCommand();
    }

    public String toString() {
        return super.toString() + this.sequenceFlow;
    }

    private void buildMultipleCommand() {
        Sequence<Measurement> measurements = this.sequenceFlow.getMeasurements();
        for (Measurement measurement : measurements) {
            this.addCommand(new RemoveMeasurementCommand(measurement));
        }
        this.addCommand(new RemoveTransitionPlainCommand(this.sequenceFlow));
    }

    private static class RemoveTransitionPlainCommand
    extends ProjectCommand {
        private final SequenceFlow sequenceFlow;

        private RemoveTransitionPlainCommand(@NotNull SequenceFlow sequenceFlow) {
            super(sequenceFlow);
            this.sequenceFlow = sequenceFlow;
        }

        @Override
        public String getName() {
            return ProjectCommandMsg.REMOVE.getString();
        }

        @Override
        public void undo() {
            try {
                this.getTransitionContainer().addChild(this.sequenceFlow);
            }
            catch (ProjectException e) {
                Log.logWarning(e);
            }
        }

        @Override
        public Object execute() throws ExecutionException {
            try {
                if (this.getTransitionContainer().contains(this.sequenceFlow)) {
                    this.getTransitionContainer().removeChild(this.sequenceFlow);
                }
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
            return true;
        }

        private NodeContainer getTransitionContainer() {
            return this.sequenceFlow.getParentObject();
        }
    }
}

