/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.RemoveActivityCommand;
import oracle.bpm.project.command.design.RemoveConnectorCommand;
import oracle.bpm.project.command.design.ShiftObjectsCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.util.ModelUtils;

public class RemoveLaneCommand
extends MultipleCommand {
    private Lane lane;
    private int location;
    private List<ProjectObject> removedActivities = new ArrayList<ProjectObject>();
    private int shift;

    public RemoveLaneCommand(Lane lane) {
        super(new ProjectObject[0]);
        this.lane = lane;
        this.location = lane.getOffset();
        this.shift = lane.getSize();
        this.buildMultipleCommand();
    }

    public String toString() {
        return super.toString() + this.lane;
    }

    @Override
    public ProjectObject getAffectedObject() {
        return this.lane;
    }

    @Override
    public Object execute() throws ExecutionException {
        if (this.lane.getProcess().getLanes().toArray().length == 1) {
            throw new ExecutionException(ProjectCommandMsg.ERASE_VIRTUAL.getString());
        }
        return super.execute();
    }

    private void buildMultipleCommand() {
        if (this.lane.getProcess().getLanes().toArray().length > 1) {
            this.addRemoveActivitiesCommand(this.lane);
            this.addRemoveConnectorsCommand(this.lane);
            this.addCommand(new RemoveLanePlainCommand(this.lane));
            this.removedActivities.add(this.lane);
            this.addCommand(new ShiftObjectsCommand(this.lane.getProcess(), this.location, -this.shift, false, this.removedActivities));
        }
    }

    private void addRemoveActivitiesCommand(Lane activityLane) {
        for (FlowNode act : activityLane.getProcess().getFlowNodes()) {
            if (act.getLane() != activityLane || !ModelUtils.canDelete(act)) continue;
            this.addCommand(new RemoveActivityCommand(act));
            this.removedActivities.add(act);
        }
    }

    private void addRemoveConnectorsCommand(Lane relatedLane) {
        for (ThrowEvent connector : relatedLane.getProcess().getEvents(ThrowEvent.class, EventTriggerType.LINK)) {
            if (connector.getLane() != relatedLane) continue;
            this.addCommand(new RemoveConnectorCommand(connector));
        }
    }

    public static class RemoveLanePlainCommand
    extends ProjectCommand {
        private Lane lane;

        public RemoveLanePlainCommand(Lane object) {
            super(new ProjectObject[0]);
            this.lane = object;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Object execute() {
            try {
                this.lane.getProcess().removeChild(this.lane);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.lane;
        }

        @Override
        public void undo() {
            try {
                this.lane.getProcess().addChild(this.lane);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
        }
    }
}

