/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.RemoveTransitionCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ThrowEvent;

public class RemoveConnectorCommand
extends MultipleCommand {
    private ThrowEvent connector;

    public RemoveConnectorCommand(ThrowEvent connector) {
        super(new ProjectObject[0]);
        this.connector = connector;
        this.buildMultipleCommand();
    }

    public String toString() {
        return super.toString() + this.connector;
    }

    private void buildMultipleCommand() {
        this.removeAssociatedTransitions(this.connector);
        this.addCommand(new RemoveConnectorPlainCommand(this.connector));
    }

    private void removeAssociatedTransitions(ThrowEvent connectorController) {
        for (SequenceFlow transition : connectorController.getIncomingSequenceFlows()) {
            this.addCommand(new RemoveTransitionCommand(transition));
        }
    }

    private static class RemoveConnectorPlainCommand
    extends ProjectCommand {
        private ThrowEvent connector;
        private Process model;

        public RemoveConnectorPlainCommand(ThrowEvent connector) {
            super(new ProjectObject[0]);
            this.model = connector.getProcess();
            this.connector = connector;
        }

        @Override
        public Object execute() throws ExecutionException {
            try {
                this.model.removeChild(this.connector);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
            return null;
        }

        @Override
        public void undo() {
            try {
                this.model.addChild(this.connector);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

