/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.ArrayList;
import java.util.ListIterator;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.ChangeSequenceFlowRoutingDataCommand;
import oracle.bpm.project.command.design.ChangeTransitionTargetCommand;
import oracle.bpm.project.command.design.RemoveTransitionCommand;
import oracle.bpm.project.command.factory.CommandFactoryProvider;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAssociatedTransitionsCommand
extends MultipleCommand {
    private FlowNode flowNode;
    private SequenceFlow outSequenceFlow;
    private ArrayList<Command> undoCommands = new ArrayList();

    public RemoveAssociatedTransitionsCommand(@NotNull FlowNode flowNode) {
        super(new ProjectObject[0]);
        this.flowNode = flowNode;
    }

    public RemoveAssociatedTransitionsCommand(@NotNull FlowNode flowNode, @Nullable SequenceFlow outSequenceFlow) {
        super(new ProjectObject[0]);
        this.flowNode = flowNode;
        this.outSequenceFlow = outSequenceFlow;
    }

    @Override
    public ProjectObject getAffectedObject() {
        return this.flowNode;
    }

    @Override
    public Object execute() {
        FlowNode newTarget = null;
        Sequence<SequenceFlow> flows = this.flowNode.getOutgoingSequenceFlows();
        for (SequenceFlow flow : flows) {
            this.execute(new RemoveTransitionCommand(flow));
            if (this.outSequenceFlow != null && !flow.getId().equals(this.outSequenceFlow.getId())) continue;
            newTarget = flow.getTarget();
        }
        flows = this.flowNode.getIncomingSequenceFlows();
        for (SequenceFlow flow : flows) {
            FlowNode source = flow.getSource();
            if (!(ModelUtils.isEndEvent(this.flowNode) || !ModelUtils.getSequenceFlowsBetween(source, newTarget).isEmpty() || newTarget == null || newTarget.equals(source) || ModelUtils.isBoundaryEvent(source) && newTarget.equals(source.asAnyNode(BoundaryEvent.class).getBoundaryActivity()))) {
                this.execute(new ChangeTransitionTargetCommand(flow, newTarget));
                this.execute(new ChangeSequenceFlowRoutingDataCommand(flow, RoutingMode.STRAIGHT, SequenceFlow.NULL_CONTROL_POINT));
                continue;
            }
            this.execute(CommandFactoryProvider.getCommandFactory().createRemoveTransitionCommand(flow));
        }
        return super.execute();
    }

    @Override
    public void undo() {
        ListIterator<Command> lit = this.undoCommands.listIterator(this.undoCommands.size());
        while (lit.hasPrevious()) {
            Command undoableAction = lit.previous();
            undoableAction.undo();
        }
    }

    private void execute(Command command) {
        command.execute();
        this.undoCommands.add(command);
    }
}

