/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class RemoveActivityPlainCommand
extends ProjectCommand {
    private FlowNode flowNode;

    public RemoveActivityPlainCommand(@NotNull FlowNode flowNode) {
        super(flowNode);
        this.flowNode = flowNode;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.REMOVE.getString();
    }

    @Override
    public Object execute() {
        if (ModelUtils.contains(this.getNodeContainer(), this.flowNode)) {
            try {
                this.getNodeContainer().removeChild(this.flowNode);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.flowNode;
    }

    @Override
    public void undo() {
        if (!ModelUtils.contains(this.getNodeContainer(), this.flowNode)) {
            try {
                this.getNodeContainer().addChild(this.flowNode);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
        }
    }

    private NodeContainer getNodeContainer() {
        return this.flowNode.getParentObject();
    }
}

