/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.ChangeTargetForNoteCommand;
import oracle.bpm.project.command.design.RemoveActivityPlainCommand;
import oracle.bpm.project.command.design.RemoveAssociatedTransitionsCommand;
import oracle.bpm.project.command.design.RemoveConnectorCommand;
import oracle.bpm.project.command.design.ToggleCounterCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveActivityCommand
extends MultipleCommand {
    private final FlowNode flowNode;
    private SequenceFlow outSequenceFlow;

    public RemoveActivityCommand(FlowNode flowNode) {
        super(flowNode);
        this.flowNode = flowNode;
        this.buildMultipleCommand();
    }

    public RemoveActivityCommand(FlowNode flowNode, @Nullable SequenceFlow outSequenceFlow) {
        super(flowNode);
        this.flowNode = flowNode;
        this.outSequenceFlow = outSequenceFlow;
        this.buildMultipleCommand();
    }

    public String toString() {
        return super.toString() + this.flowNode + "from container: " + this.flowNode.getParentObject();
    }

    private void buildMultipleCommand() {
        if (ModelUtils.canDelete(this.flowNode)) {
            this.addCommand(new RemoveActivityAndRelationsCommand(this.flowNode, this.outSequenceFlow));
            this.removeAssociatedActivity(this.flowNode);
        }
    }

    private void removeAssociatedActivity(FlowNode flowNode) {
        FlowNode associated;
        NodeAssociationFeature feature = flowNode.getFeature(NodeAssociationFeature.class);
        if (feature != null && !flowNode.isEvent() && (associated = feature.getAssociatedNode()) != null) {
            this.addCommand(new RemoveActivityAndRelationsCommand(associated));
        }
        if (flowNode.isActivity()) {
            Activity activity = flowNode.asAnyNode(Activity.class);
            for (BoundaryEvent boundary : activity.getActivityBoundaryEvents()) {
                this.addCommand(new RemoveActivityAndRelationsCommand(boundary));
            }
        }
    }

    private static class RemoveActivityAndRelationsCommand
    extends MultipleCommand {
        private final FlowNode flowNode;
        private SequenceFlow outSequenceFlow;

        public RemoveActivityAndRelationsCommand(@NotNull FlowNode flowNode) {
            super(new ProjectObject[0]);
            this.flowNode = flowNode;
            this.buildMultipleCommand();
        }

        public RemoveActivityAndRelationsCommand(FlowNode flowNode, @Nullable SequenceFlow outSequenceFlow) {
            super(new ProjectObject[0]);
            this.flowNode = flowNode;
            this.outSequenceFlow = outSequenceFlow;
            this.buildMultipleCommand();
        }

        @Override
        public ProjectObject getAffectedObject() {
            return this.flowNode;
        }

        private void buildMultipleCommand() {
            if (this.outSequenceFlow != null) {
                this.addCommand(new RemoveAssociatedTransitionsCommand(this.flowNode, this.outSequenceFlow));
            } else {
                this.addCommand(new RemoveAssociatedTransitionsCommand(this.flowNode));
            }
            this.removeAssociatedConnectors(this.flowNode);
            this.removeAssociatedNotes(this.flowNode);
            this.removeAssociatedCounter(this.flowNode);
            this.removeAssociatedMilestones(this.flowNode);
            this.addCommand(new RemoveActivityPlainCommand(this.flowNode));
        }

        private void removeAssociatedNotes(FlowNode so) {
            Sequence<TextAnnotation> notes = so.getProcess().getTextAnnotations();
            for (TextAnnotation note : notes) {
                if (note.getTarget() != so) continue;
                this.addCommand(new ChangeTargetForNoteCommand(note, null));
            }
        }

        private void removeAssociatedConnectors(FlowNode fuegoNode) {
            Sequence<ThrowEvent> connectors = fuegoNode.getProcess().getEvents(ThrowEvent.class, EventTriggerType.LINK);
            for (ThrowEvent connector : connectors) {
                NodeAssociationFeature nodeAssociationFeature = connector.getFeature(NodeAssociationFeature.class);
                if (nodeAssociationFeature.getAssociatedNode() != fuegoNode) continue;
                this.addCommand(new RemoveConnectorCommand(connector));
            }
        }

        private void removeAssociatedCounter(FlowNode fuegoNode) {
            Counter counter = ModelUtils.getCounterFor(fuegoNode);
            if (counter != null) {
                this.addCommand(new ToggleCounterCommand(counter));
            }
        }

        private void removeAssociatedMilestones(FlowNode node) {
            ActivityGuide guide = node.getProject().getActivityGuide();
            Sequence<Milestone> childrenByType = guide.getChildrenByType(Milestone.class);
            block0: for (Milestone milestone : childrenByType) {
                Sequence<MilestoneActivity> activitySequence = milestone.getChildrenByType(MilestoneActivity.class);
                for (MilestoneActivity milestoneActivity : activitySequence) {
                    if (!milestoneActivity.getActivity().equals(node)) continue;
                    this.addCommand(new SimpleDeleteCommand(milestone, milestoneActivity));
                    continue block0;
                }
            }
        }
    }

    public static class SimpleDeleteCommand
    implements Command {
        private final ProjectObject object;
        private final ProjectObject parent;

        public SimpleDeleteCommand(ProjectObject parent, ProjectObject object) {
            this.parent = parent;
            this.object = object;
        }

        @Override
        public String getName() {
            return ProjectCommandMsg.DELETE.getString();
        }

        @Override
        public Object getAffectedObject() {
            return this.parent;
        }

        @Override
        public void undo() {
            try {
                if (this.parent instanceof ProjectObjectContainer) {
                    ((ProjectObjectContainer)this.parent).addChild(this.object);
                }
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public Object execute() throws ExecutionException {
            try {
                this.object.delete();
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
            return null;
        }
    }
}

