/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class CopySequenceFlowCommand
extends ProjectCommand {
    private SequenceFlow originalTarget;
    private final SequenceFlow source;
    private final SequenceFlow target;

    public CopySequenceFlowCommand(@NotNull SequenceFlow source, @NotNull SequenceFlow target) {
        super(source.getProcess());
        this.originalTarget = target.copy();
        this.source = source;
        this.target = target;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CHANGES_IN(this.source.getDefaultLabel()).getString();
    }

    @Override
    public Object execute() {
        try {
            this.target.applyFrom(this.source);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return this.target;
    }

    @Override
    public void undo() {
        try {
            this.target.applyFrom(this.originalTarget);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
    }
}

