/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.CorrelationKey;
import org.jetbrains.annotations.NotNull;

public class CopyCorrelationKeyCommand
extends ProjectCommand {
    private CorrelationKey originalTarget;
    private final CorrelationKey source;
    private final CorrelationKey target;

    public CopyCorrelationKeyCommand(@NotNull CorrelationKey source, @NotNull CorrelationKey target) {
        super(source.getParentObject());
        this.originalTarget = (CorrelationKey)target.copy();
        this.source = source;
        this.target = target;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CHANGES_IN(this.source.getId()).getString();
    }

    @Override
    public Object execute() {
        this.target.applyFrom(this.source);
        return this.target;
    }

    @Override
    public void undo() {
        this.target.applyFrom(this.originalTarget);
    }
}

