/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.conversation.Conversation;
import org.jetbrains.annotations.NotNull;

public class CopyConversationCommand
extends ProjectCommand {
    private Conversation originalTarget;
    private final Conversation source;
    private final Conversation target;

    public CopyConversationCommand(@NotNull Conversation source, @NotNull Conversation target) {
        super(source.getParentObject());
        this.originalTarget = (Conversation)target.copy();
        this.source = source;
        this.target = target;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CHANGES_IN(this.source.getName()).getString();
    }

    @Override
    public Object execute() {
        this.target.applyFrom(this.source);
        return this.target;
    }

    @Override
    public void undo() {
        this.target.applyFrom(this.originalTarget);
    }
}

