/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class ChangeTriggerTypeCommand
extends ProjectCommand {
    private final EventTriggerType original;
    private final EventTriggerType type;

    public ChangeTriggerTypeCommand(@NotNull Event event, @NotNull EventTriggerType type) {
        super(event);
        this.type = type;
        this.original = event.getEventTriggerType();
    }

    public static List<EventTriggerType> getAllPosibleChanges(Event event) {
        ArrayList<EventTriggerType> list = new ArrayList<EventTriggerType>();
        boolean isBoundary = ModelUtils.isBoundaryEvent(event);
        boolean isOnRegularSubprocess = ChangeTriggerTypeCommand.isParentRegularSubprocess(event);
        boolean isOnEventSubprocess = ChangeTriggerTypeCommand.isParentEventSubprocess(event);
        if (isBoundary) {
            list.add(EventTriggerType.MESSAGE);
            list.add(EventTriggerType.TIMER);
            list.add(EventTriggerType.ERROR);
            list.add(EventTriggerType.SIGNAL);
        } else if (event.isCatchEvent()) {
            if (event.isStart()) {
                if (!isOnEventSubprocess) {
                    list.add(EventTriggerType.NONE);
                }
                if (!isOnRegularSubprocess) {
                    list.add(EventTriggerType.MESSAGE);
                    list.add(EventTriggerType.TIMER);
                    list.add(EventTriggerType.SIGNAL);
                    if (isOnEventSubprocess) {
                        list.add(EventTriggerType.ERROR);
                    }
                }
            } else {
                list.add(EventTriggerType.NONE);
                list.add(EventTriggerType.MESSAGE);
                list.add(EventTriggerType.TIMER);
                list.add(EventTriggerType.SIGNAL);
            }
        } else if (event.isThrowEvent()) {
            list.add(EventTriggerType.NONE);
            list.add(EventTriggerType.MESSAGE);
            list.add(EventTriggerType.SIGNAL);
            if (event.isEnd()) {
                list.add(EventTriggerType.ERROR);
                list.add(EventTriggerType.TERMINATE);
            }
        }
        return list;
    }

    @Override
    public String getName() {
        return this.type.getString();
    }

    @Override
    public Object execute() {
        Event event = this.getAffectedObject();
        event.setEventTriggerType(this.type);
        return event;
    }

    @Override
    public void undo() {
        this.getAffectedObject().setEventTriggerType(this.original);
    }

    @Override
    public Event getAffectedObject() {
        return (Event)super.getAffectedObject();
    }

    private static boolean isParentRegularSubprocess(@NotNull Event event) {
        NodeContainer parent = event.getParentObject();
        return parent instanceof Subprocess && !((Subprocess)parent).isTriggeredByEvent();
    }

    private static boolean isParentEventSubprocess(@NotNull Event event) {
        NodeContainer parent = event.getParentObject();
        return parent instanceof Subprocess && ((Subprocess)parent).isTriggeredByEvent();
    }

    private static boolean isParentCallableProcess(@NotNull Event event) {
        NodeContainer parent = event.getParentObject();
        return parent instanceof Process && ((Process)parent).isCallableSubprocess();
    }

    private static boolean isParentRegularProcess(@NotNull Event event) {
        NodeContainer parent = event.getParentObject();
        return parent instanceof Process && !((Process)parent).isCallableSubprocess();
    }
}

