/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTransitionSourceCommand
extends ProjectCommand {
    @NotNull
    private SequenceFlow flow;
    private FlowNode prevSource;
    private FlowNode source;

    public ChangeTransitionSourceCommand(@NotNull SequenceFlow flow, @Nullable FlowNode source) {
        super(flow);
        this.flow = flow;
        this.source = source;
        this.prevSource = flow.getSource();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_TRANSITION(this.flow).getString();
    }

    @Override
    public Object execute() {
        if (this.source != null) {
            try {
                if (ModelUtils.checkSourceRelocation(this.flow, this.source)) {
                    ModelUtils.translateAndRotateControlPoint(this.flow, this.flow.getSource(), this.source.getLocation());
                    this.flow.setSource(this.source);
                    return true;
                }
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.flow + ", source: " + this.source;
    }

    @Override
    public void undo() {
        ModelUtils.translateAndRotateControlPoint(this.flow, this.flow.getSource(), this.prevSource.getLocation());
        this.flow.setSource(this.prevSource);
    }
}

