/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.TextAnnotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTargetForNoteCommand
extends ProjectCommand {
    private FlowNode newTarget;
    private FlowNode prevTarget;

    public ChangeTargetForNoteCommand(@NotNull TextAnnotation note, @Nullable FlowNode newTarget) {
        super(note);
        this.prevTarget = note.getTarget();
        this.newTarget = newTarget;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CHANGE_TARGET.getString();
    }

    @Override
    public Object execute() {
        this.getAffectedObject().setTarget(this.newTarget);
        return null;
    }

    @Override
    public void undo() {
        this.getAffectedObject().setTarget(this.prevTarget);
    }

    @Override
    public TextAnnotation getAffectedObject() {
        return (TextAnnotation)super.getAffectedObject();
    }
}

