/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.geom.Point;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class ChangeSequenceFlowRoutingDataCommand
extends ProjectCommand {
    private final Point control;
    private final RoutingMode mode;
    private Point previousControl;
    private RoutingMode previousMode;

    public ChangeSequenceFlowRoutingDataCommand(@NotNull SequenceFlow sequenceFlow, @NotNull RoutingMode mode, @NotNull Point control) {
        super(sequenceFlow);
        this.mode = mode;
        this.control = control;
    }

    @Override
    public Object execute() {
        SequenceFlow sequenceFlow = this.getSequenceFlow();
        this.previousControl = sequenceFlow.getControlPoint();
        this.previousMode = sequenceFlow.getRoutingMode();
        sequenceFlow.setRoutingData(this.mode, this.control);
        return sequenceFlow;
    }

    @Override
    public void undo() {
        this.getSequenceFlow().setRoutingData(this.previousMode, this.previousControl);
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CHANGE_SEQUENCEFLOW_STYLE.toString();
    }

    private SequenceFlow getSequenceFlow() {
        return (SequenceFlow)this.getAffectedObject();
    }
}

