/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.ShiftObjectsCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.CustomizedImageFeature;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class AddLaneCommand
extends MultipleCommand {
    private String customImage;
    private final Lane lane;
    private final int offset;
    private final boolean rescan;
    private boolean shiftObjects;
    private int size;

    public AddLaneCommand(@NotNull Lane lane, int offset, boolean shiftObjects) {
        super(new ProjectObject[0]);
        this.lane = lane;
        this.offset = offset;
        this.rescan = true;
        this.shiftObjects = shiftObjects;
        this.size = LaneUtils.calculateMinimunLaneSize(lane.getSize(), lane.getRole());
        this.build();
    }

    public AddLaneCommand(@NotNull Lane lane, int offset, int size, boolean shiftObjects) {
        super(new ProjectObject[0]);
        this.lane = lane;
        this.offset = offset;
        this.rescan = true;
        this.shiftObjects = shiftObjects;
        this.size = size;
        this.build();
    }

    public AddLaneCommand(@NotNull Process process, @NotNull String name, int backgroundColor, int offset) {
        this(process, name, backgroundColor, offset, 200);
    }

    public AddLaneCommand(@NotNull Process process, @NotNull String name, int backgroundColor, int offset, boolean shiftObjects) {
        this(process, name, backgroundColor, offset, 200, true, shiftObjects);
    }

    public AddLaneCommand(@NotNull Process process, @NotNull String name, int backgroundColor, int offset, int size) {
        this(process, name, backgroundColor, offset, size, true);
    }

    public AddLaneCommand(@NotNull Process process, @NotNull String name, int backgroundColor, int offset, int size, boolean rescan) {
        this(process, name, backgroundColor, offset, size, rescan, false);
    }

    public AddLaneCommand(@NotNull Process process, @NotNull String name, int backgroundColor, int offset, int size, boolean rescan, boolean shiftObjects) {
        super(new ProjectObject[0]);
        this.offset = offset;
        this.rescan = rescan;
        this.size = size;
        this.shiftObjects = shiftObjects;
        this.lane = process.createLane(name);
        this.lane.setBackgroundColor(backgroundColor);
        if (!this.lane.isAutomatic()) {
            Role role = process.getProject().getOrganization().findRoleById(name);
            this.lane.setDefaultLabel(role.getName());
        }
        this.build();
    }

    @Override
    public Lane getAffectedObject() {
        return this.lane;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.lane.getRole()).getString();
    }

    public void setCustomImage(String customImage) {
        this.customImage = customImage;
        this.lane.getFeature(CustomizedImageFeature.class).setValue(customImage);
    }

    private void build() {
        this.lane.setSize(this.size);
        if (this.shiftObjects) {
            this.addCommand(new ShiftObjectsCommand(this.lane.getProcess(), this.offset + 1, this.lane.getSize(), this.rescan));
        }
        this.addCommand(new ProjectCommand(new ProjectObject[0]){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public Object execute() throws ExecutionException {
                AddLaneCommand.this.lane.setOffset(AddLaneCommand.this.offset);
                try {
                    AddLaneCommand.this.lane.getProcess().addChild(AddLaneCommand.this.lane);
                }
                catch (ProjectException e) {
                    throw new ExecutionException(e);
                }
                return null;
            }

            @Override
            public void undo() {
                try {
                    AddLaneCommand.this.lane.getProcess().removeChild(AddLaneCommand.this.lane);
                }
                catch (ProjectException e) {
                    Log.logWarning(e);
                }
            }
        });
    }
}

