/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import org.jetbrains.annotations.NotNull;

public class AddConversationCommand
extends ProjectCommand {
    private Conversation conversation;

    public AddConversationCommand(@NotNull ConversationContainer conversationContainer, @NotNull Conversation conversation) {
        super(conversationContainer);
        this.conversation = conversation;
    }

    @Override
    public Object execute() {
        try {
            this.getConversationContainer().addConversation(this.conversation);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return this.conversation;
    }

    @Override
    public void undo() {
        try {
            ConversationContainer nodeContainer = this.getConversationContainer();
            if (nodeContainer.findChild(Conversation.class, this.conversation.getId()) != null) {
                this.getConversationContainer().removeConversation(this.conversation);
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.conversation.getId()).getString();
    }

    private ConversationContainer getConversationContainer() {
        return (ConversationContainer)this.getAffectedObject();
    }
}

