/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.activityguide;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.exception.ProjectException;

public class MoveActivityToMilestoneCommand
extends ProjectCommand {
    private MilestoneActivity milestoneActivity;
    private Milestone toMilestone;

    public MoveActivityToMilestoneCommand(MilestoneActivity milestoneActivity, Milestone toMilestone) {
        super(new ProjectObject[0]);
        this.milestoneActivity = milestoneActivity;
        this.toMilestone = toMilestone;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.milestoneActivity.getId()).toString();
    }

    @Override
    public Object execute() throws ExecutionException {
        try {
            MilestoneActivity newMilestoneActivity = this.milestoneActivity.clone(this.toMilestone);
            Milestone milestone = (Milestone)this.milestoneActivity.getParentObject();
            milestone.removeChild(this.milestoneActivity);
            this.toMilestone.addChild(newMilestoneActivity);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return this.milestoneActivity;
    }

    @Override
    public void undo() {
        try {
            Milestone milestone = (Milestone)this.milestoneActivity.getParentObject();
            milestone.addChild(this.milestoneActivity);
            this.toMilestone.removeChild(this.milestoneActivity);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
    }
}

