/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.resources.Msg;

public class MultipleCommand
extends ProjectCommand {
    private List<Command> commands;
    private Command lastCommand;
    private List<ActionExecutionListener> listeners = new ArrayList<ActionExecutionListener>();
    private Msg msg;

    public MultipleCommand(ProjectObject ... projectObjects) {
        super(projectObjects);
    }

    public void addActionExecutionListener(ActionExecutionListener lis) {
        if (!this.listeners.contains(lis)) {
            this.listeners.add(lis);
        }
    }

    public void addCommand(Command action) {
        this.getCommands().add(action);
    }

    public void addCommands(Collection<Command> collection) {
        for (Command command : collection) {
            this.addCommand(command);
        }
    }

    @Override
    public Object execute() throws ExecutionException {
        this.executeAllOrNothing();
        return null;
    }

    @Override
    public void undo() {
        this.undoEverything();
    }

    public List<Command> getCommands() {
        if (this.commands == null) {
            this.commands = new ArrayList<Command>();
        }
        return this.commands;
    }

    @Override
    public String getName() {
        if (this.msg != null) {
            return this.msg.getString();
        }
        return this.commands != null && this.commands.size() > 0 ? this.commands.get(this.commands.size() - 1).getName() : "Multiple Command";
    }

    public void setMsg(Msg msg) {
        this.msg = msg;
    }

    public void setUndoReverse(boolean undoReverse) {
    }

    private void undoEverything() {
        ListIterator<Command> lit = this.getCommands().listIterator(this.getCommands().size());
        while (lit.hasPrevious()) {
            Command undoableAction = lit.previous();
            if (undoableAction == this.lastCommand) continue;
            undoableAction.undo();
        }
    }

    private void executeAllOrNothing() {
        this.lastCommand = null;
        for (Command currentCommand : this.getCommands()) {
            try {
                this.lastCommand = currentCommand;
                this.lastCommand.execute();
                this.notifyActionExecuted(this.lastCommand);
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Throwable dee) {
                throw new ExecutionException(dee);
            }
        }
        this.lastCommand = null;
    }

    private void notifyActionExecuted(Command action) {
        for (ActionExecutionListener listener : this.listeners) {
            listener.actionExecuted(action);
        }
    }

    public static abstract class ActionExecutionListener {
        public abstract void actionExecuted(Command var1);
    }
}

