/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.model;

import java.util.LinkedList;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardCancelStep;
import oracle.bpm.ui.wizards.model.WizardStepTransition;
import oracle.bpm.ui.wizards.model.WizardSupport;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

public abstract class WizardStep {
    private boolean allowsBack;
    private WizardStep nextStep;
    private Wizard ownerWizard;
    private WizardStep previousStep;
    private WizardStepPanel stepPanel;
    private WizardStepTransition stepTransition;

    protected WizardStep(Wizard owner) {
        this.setWizard(owner);
        this.allowsBack = true;
    }

    protected WizardStep(Wizard owner, WizardStepTransition transition) {
        this.setWizard(owner);
        this.setStepTransition(transition);
        this.allowsBack = true;
    }

    protected WizardStep(Wizard owner, boolean allowsBackwardMovement) {
        this(owner);
        this.allowsBack = allowsBackwardMovement;
    }

    protected WizardStep(Wizard owner, WizardStepTransition transition, boolean allowsBackwardMovement) {
        this.setWizard(owner);
        this.setStepTransition(transition);
        this.allowsBack = allowsBackwardMovement;
    }

    public abstract boolean doProcess();

    public abstract void undoProcess();

    public void setNextStep(WizardStep aStep) {
        this.nextStep = aStep;
    }

    public WizardStep getNextStep() {
        WizardStepTransition st;
        if (this.nextStep == null && (st = this.getStepTransition()) != null) {
            return st.getNextStepFor(this);
        }
        return this.nextStep;
    }

    public void setPreviousStep(WizardStep aStep) {
        this.previousStep = aStep;
    }

    public WizardStep getPreviousStep() {
        return this.previousStep;
    }

    public WizardStepPanel getStepPanel() {
        return this.stepPanel;
    }

    public final WizardStepPanel getStepPanelFor(UiContainer parent, WizardSupport support) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent for StepPanel cannot be null");
        }
        this.setStepPanel(this.getPanelFor(parent));
        support.setCurrentPanel(this.getStepPanel());
        this.getStepPanel().initialize();
        assert (this.getStepPanel() != null) : "step panel must not be null!";
        support.ensureSize();
        return this.getStepPanel();
    }

    public void setStepTransition(WizardStepTransition stepTransition) {
        this.stepTransition = stepTransition;
    }

    public WizardStepTransition getStepTransition() {
        return this.stepTransition;
    }

    public void setWizard(Wizard wizard) {
        this.ownerWizard = wizard;
    }

    public Wizard getWizard() {
        return this.ownerWizard;
    }

    public boolean allowsBackwardMovement() {
        return this.allowsBack;
    }

    public boolean canMoveBack() {
        return this.hasPreviousStep() && this.allowsBackwardMovement();
    }

    public String getStepName() {
        return this.getClass().getName() + "/" + this.hashCode();
    }

    public boolean hasNextStep() {
        return this.getNextStep() != null;
    }

    public boolean hasPreviousStep() {
        return this.getPreviousStep() != null;
    }

    public final void moveBackwards() {
        if (this.canMoveBack()) {
            this.undoProcess();
            this.getPreviousStep().setNextStep(null);
            this.getPreviousStep().showIn(this.getWizard().getSupport());
            this.getWizard().updateTitle(this.getPreviousStep());
        }
    }

    public void moveForward() {
        if (this.doProcess()) {
            this.getNextStep().setPreviousStep(this);
            this.getNextStep().showIn(this.getWizard().getSupport());
            this.getWizard().updateTitle(this.getNextStep());
        }
    }

    public void showIn(WizardSupport support) {
        WizardStepPanel panel = this.getStepPanelFor(support.getExtensionParent(), support);
        support.showStep(panel);
        panel.onFocus();
    }

    public final boolean cancel() {
        MessageDialog.setFrame(this.getWizard().getSupport().getExtensionParent());
        int result = MessageDialog.showQuestion(UIMsg.CONFIRM_ACTION, UIMsg.CANCEL_WIZARD, 6);
        if (result == 2) {
            this.cancelProcess();
            this.getWizard().setCancelled(true);
            if (this.getWizard().showCancelSummaryPage()) {
                WizardCancelStep cancelStep = new WizardCancelStep(this.getWizard());
                this.setNextStep(cancelStep);
                cancelStep.setPreviousStep(this);
                this.getNextStep().showIn(this.getWizard().getSupport());
            }
            return true;
        }
        return false;
    }

    public void cancelProcess() {
        this.undoProcess();
        if (this.hasPreviousStep()) {
            this.getPreviousStep().cancelProcess();
        }
    }

    public void setStepPanel(WizardStepPanel stepPanel) {
        this.stepPanel = stepPanel;
    }

    public boolean isLastStep() {
        return this.getWizard().isLastStep(this);
    }

    public boolean isFirstStep() {
        return this.getWizard().isFirstStep(this);
    }

    public Button getNextButton() {
        return this.getWizard().getSupport().getNextButton();
    }

    public Button getBackButton() {
        return this.getWizard().getSupport().getBackButton();
    }

    public Button getCancelButton() {
        return this.getWizard().getSupport().getCancelButton();
    }

    public WizardStep getRelativeStep(int deltaStep) {
        return this.getWizardSteps().get(this.getIndex() + deltaStep);
    }

    public int getIndex() {
        return this.getWizardSteps().indexOf(this);
    }

    public boolean isFinishable() {
        return false;
    }

    public boolean isSummaryStep() {
        return false;
    }

    public Button getFinishButton() {
        return this.getWizard().getSupport().getFinishButton();
    }

    protected abstract WizardStepPanel getPanelFor(UiContainer var1);

    protected void traceException(Exception exception, Msg message) {
        Log.logWarning((Throwable)exception);
        MessageDialog.showError(message, UIMsg.TO_MSG(exception.getMessage()), exception);
    }

    protected void traceException(Exception exception) {
        Log.logWarning((Throwable)exception);
        MessageDialog.showError(exception);
    }

    private LinkedList<WizardStep> getWizardSteps() {
        return this.getWizard().getSteps();
    }
}

