/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.utils;

import oracle.bpm.ui.Box;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.utils.Layout;

public class RelativeLayouter {
    private String[] columns;
    private ComponentSpec[][] componentSpecs;
    private UiContainer container;
    private String[][] names;
    private int qcols;
    private int qrows;
    private String[] rows;
    private Spec spec;
    public static byte ALIGNED_TOP = 1;
    public static byte ALIGNED_RIGHT = (byte)2;
    public static byte VERTICALLY_CENTERED = (byte)4;
    public static byte HORIZONTALLY_CENTERED = (byte)8;
    private static final String HSTRUT = "hstrut";
    private static final String VSTRUT = "vstrut";

    public RelativeLayouter(Spec spec, ComponentSpec[][] componentSpecs, UiContainer container) {
        this.setSpec(spec);
        this.setComponentSpecs(componentSpecs);
        this.setRows(componentSpecs.length);
        this.setCols(componentSpecs[0].length);
        this.setContainer(container);
    }

    public UiContainer layout() {
        int i;
        RelativeLayout relativeLayout = null;
        if (!(this.container.getLayout() instanceof RelativeLayout)) {
            throw new IllegalArgumentException("RelativeLayouter assumes a layout RelativeLayout");
        }
        relativeLayout = (RelativeLayout)this.container.getLayout();
        this.initState();
        for (i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                if (this.componentSpecs[i][j] == null) continue;
                ComponentSpec componentSpec = this.componentSpecs[i][j];
                if (this.check(componentSpec.modifiers, VERTICALLY_CENTERED)) {
                    Layout.fixToComp(relativeLayout, this.names[i][j], AttributeType.VERTICAL_CENTER, this.rows[i].replaceAll(this.names[i][j], ""));
                } else if (this.check(componentSpec.modifiers, ALIGNED_TOP)) {
                    Layout.fixToComp(relativeLayout, this.names[i][j], AttributeType.TOP, this.rows[i].replaceAll(this.names[i][j], ""), AttributeType.TOP, 0);
                } else if (i == this.getRows() - 1) {
                    Layout.fixToRoot(relativeLayout, this.names[i][j], AttributeType.BOTTOM, -this.getSpec().vOuterGap);
                } else {
                    Layout.fixToComp(relativeLayout, this.names[i][j], AttributeType.BOTTOM, this.rows[i + 1], AttributeType.TOP, -this.getSpec().vInnerGap);
                }
                if (this.check(componentSpec.modifiers, HORIZONTALLY_CENTERED)) {
                    Layout.fixToComp(relativeLayout, this.names[i][j], AttributeType.HORIZONTAL_CENTER, this.columns[j].replaceAll(this.names[i][j], ""));
                    continue;
                }
                if (this.check(componentSpec.modifiers, ALIGNED_RIGHT)) {
                    Layout.fixToComp(relativeLayout, this.names[i][j], AttributeType.RIGHT, this.columns[j].replaceAll(this.names[i][j], ""), AttributeType.RIGHT, 0);
                    continue;
                }
                if (j == 0) {
                    Layout.fixToRoot(relativeLayout, this.names[i][j], AttributeType.LEFT, this.getSpec().hOuterGap);
                    continue;
                }
                Layout.fixToComp(relativeLayout, this.names[i][j], AttributeType.LEFT, this.columns[j - 1], AttributeType.RIGHT, this.getSpec().hInnerGap);
            }
        }
        if (this.spec.vAnchored) {
            for (int j = 0; j < this.getCols(); ++j) {
                Layout.fixToRoot(relativeLayout, this.names[0][j], AttributeType.TOP, this.getSpec().vOuterGap);
            }
        }
        if (this.spec.hAnchored) {
            for (i = 0; i < this.getRows(); ++i) {
                Layout.fixToRoot(relativeLayout, this.names[i][this.getCols() - 1], AttributeType.RIGHT, -this.getSpec().hOuterGap);
            }
        }
        Layout.fixToComp(relativeLayout, HSTRUT, AttributeType.LEFT, this.columns[this.getCols() - 1], AttributeType.RIGHT, 0);
        Layout.fixToRoot(relativeLayout, HSTRUT, AttributeType.BOTTOM, 0);
        Layout.fixToComp(relativeLayout, VSTRUT, AttributeType.BOTTOM, this.rows[0], AttributeType.TOP, 0);
        Layout.fixToRoot(relativeLayout, VSTRUT, AttributeType.LEFT, 0);
        this.resetState();
        return this.container;
    }

    private void setCols(int cols) {
        this.qcols = cols;
    }

    private int getCols() {
        return this.qcols;
    }

    private void setComponentSpecs(ComponentSpec[][] componentSpecs) {
        this.componentSpecs = componentSpecs;
    }

    private void setContainer(UiContainer container) {
        this.container = container;
    }

    private void setRows(int rows) {
        this.qrows = rows;
    }

    private int getRows() {
        return this.qrows;
    }

    private void setSpec(Spec spec) {
        this.spec = spec;
    }

    private Spec getSpec() {
        return this.spec;
    }

    private boolean check(byte modifiers, byte mask) {
        return (modifiers & mask) != 0;
    }

    private void initState() {
        int i;
        this.names = new String[this.getRows()][this.getCols()];
        this.rows = new String[this.getRows()];
        this.columns = new String[this.getCols()];
        for (i = 0; i < this.getRows(); ++i) {
            this.rows[i] = "";
        }
        for (int j = 0; j < this.getCols(); ++j) {
            this.columns[j] = "";
        }
        this.container.add(Box.createHorizontalStrut(this.container, this.spec.hOuterGap), HSTRUT);
        this.container.add(Box.createVerticalStrut(this.container, this.spec.vOuterGap), VSTRUT);
        for (i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                if (this.componentSpecs[i][j] == null) continue;
                this.names[i][j] = "component" + i + "#" + j + "";
                this.container.add(this.componentSpecs[i][j].component, this.names[i][j]);
                int n = i;
                this.rows[n] = this.rows[n] + this.names[i][j] + ",";
                int n2 = j;
                this.columns[n2] = this.columns[n2] + this.names[i][j] + ",";
            }
        }
    }

    private void resetState() {
        this.names = null;
        this.rows = null;
        this.columns = null;
    }

    public static class Spec {
        public boolean hAnchored;
        public int hInnerGap;
        public int hOuterGap;
        public boolean vAnchored;
        public int vInnerGap;
        public int vOuterGap;

        public Spec(int hInnerGap, int vInnerGap) {
            this(0, 0, hInnerGap, vInnerGap);
        }

        public Spec(int hOuterGap, int vOuterGap, int hInnerGap, int vInnerGap) {
            this(hOuterGap, vOuterGap, hInnerGap, vInnerGap, false, false);
        }

        public Spec(int hOuterGap, int vOuterGap, int hInnerGap, int vInnerGap, boolean hAnchored, boolean vAnchored) {
            this.hOuterGap = hOuterGap;
            this.vOuterGap = vOuterGap;
            this.hInnerGap = hInnerGap;
            this.vInnerGap = vInnerGap;
            this.hAnchored = hAnchored;
            this.vAnchored = vAnchored;
        }
    }

    public static class ComponentSpec {
        UiComponent component;
        private byte modifiers;

        public ComponentSpec(UiComponent component) {
            this.component = component;
        }

        public ComponentSpec(UiComponent component, byte modifiers) {
            this.component = component;
            this.modifiers = modifiers;
        }
    }
}

