/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.toolbar;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.CustomAction;
import oracle.bpm.ui.CustomFuegoAction;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.toolbar.ToolBarDialog;
import oracle.bpm.ui.toolbar.ToolbarActionGroup;

public class CustomToolBar
extends ToolBar {
    private ToolbarActionGroup currentGroup;
    private ToolBarDialog dialog;
    private int[] groupIndices = new int[0];
    private Map groupsMap;
    private PopupMenu menu;
    public static final String ACTIONS_PROPERTY = "oracle.bpm.toolbar.custom.actions";
    public static final int NO_SEPARATOR = 0;
    public static final int ON_CREATION = 1;
    public static final int ON_VISIBLE = 2;

    public CustomToolBar(UiContainer parent) {
        super(parent);
        this.init();
    }

    public static void main(String[] args) {
        Frame frame = new Frame(UIMsg.CLOSE);
        BaseAction addAction = new BaseAction(UIMsg.ADD){

            @Override
            public void run() {
            }
        };
        AbstractCustomAction removeAction = new AbstractCustomAction(UIMsg.REMOVE);
        removeAction.setVisible(false);
        AbstractCustomAction autoHideAction = new AbstractCustomAction(UIMsg.PREFERENCES);
        autoHideAction.setVisible(false);
        CustomToolBar toolbar = new CustomToolBar(frame);
        toolbar.openGroup(UIMsg.ADD, 0);
        toolbar.add(addAction);
        toolbar.openGroup(UIMsg.REMOVE, 2);
        toolbar.add(autoHideAction);
        toolbar.addSeparator();
        toolbar.add(removeAction);
        UiContainer frameContent = frame.getContentPane();
        Panel dummyPanel = new Panel(frameContent);
        dummyPanel.setLayout(new BorderLayout());
        frameContent.add(dummyPanel, "North");
        frameContent.add(toolbar, "North");
        frame.pack();
        frame.setVisible(true);
    }

    public CustomAction[] getCustomActions() {
        ArrayList<CustomAction> actionsList = new ArrayList<CustomAction>();
        List<UiComponent> components = this.getComponents();
        for (UiComponent component : components) {
            CustomAction action = this.getCustomActionFrom(component);
            if (action == null) continue;
            actionsList.add(action);
        }
        return actionsList.toArray(new CustomAction[actionsList.size()]);
    }

    public Map getGroupsMap() {
        return this.groupsMap;
    }

    public String[] getVisibleActionCodes() {
        CustomAction[] actions;
        ArrayList<String> codes = new ArrayList<String>();
        for (CustomAction action : actions = this.getCustomActions()) {
            boolean visible = Boolean.TRUE.equals(action.getValue("oracle.bpm.action.custom.visible"));
            codes.add((visible ? (char)'T' : 'F') + action.getMsg().getCode());
        }
        return codes.toArray(new String[codes.size()]);
    }

    public void closeGroup() {
        this.currentGroup = null;
    }

    public void openGroup(Msg msg, int openMode) {
        ToolbarActionGroup group;
        List<UiComponent> components = this.getComponents();
        int groupIndex = components.size();
        this.currentGroup = group = new ToolbarActionGroup(this, msg, openMode, groupIndex);
        this.addIndex(groupIndex);
        this.add(group);
        if (openMode == 1 || openMode == 2) {
            this.add(new Separator(this, Separator.VERTICAL));
        }
        if (openMode == 2 && (components = this.getComponents()).size() > 0) {
            UiComponent component = components.get(components.size() - 1);
            Separator separator = (Separator)component;
            separator.setVisible(false);
        }
    }

    ToolbarActionGroup getCurrentGroup() {
        return this.currentGroup;
    }

    private CustomAction getCustomActionFrom(UiComponent comp) {
        AbstractButton button;
        BaseAction action;
        if (comp instanceof AbstractButton && (action = (button = (AbstractButton)comp).getAction()) instanceof CustomAction) {
            CustomAction customAction = (CustomAction)((Object)action);
            return customAction;
        }
        return null;
    }

    private void addIndex(int index) {
        if (this.groupIndices == null) {
            this.groupIndices = new int[]{index};
        } else {
            int[] array = new int[this.groupIndices.length + 1];
            System.arraycopy(this.groupIndices, 0, array, 0, this.groupIndices.length);
            array[array.length - 1] = index;
            this.groupIndices = array;
        }
    }

    private void init() {
        this.groupsMap = new LinkedHashMap();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CustomToolBar.this.showPopup(e.getX(), e.getY());
                }
            }
        });
    }

    private void showDialog() {
        if (this.dialog == null) {
            this.dialog = new ToolBarDialog(this.getOwnerWindow(), this);
            this.dialog.setSize(350, 400);
        }
        this.dialog.reset();
        this.dialog.setVisible(true);
        if (this.dialog.userAccepted()) {
            this.updateGroups();
        }
    }

    private void showPopup(int x, int y) {
        if (this.menu == null) {
            this.menu = new PopupMenu();
            this.menu.add(new BaseAction(UIMsg.CUSTOMIZE){

                @Override
                public void run() {
                    CustomToolBar.this.showDialog();
                }
            });
        }
        if (this.menu.isVisible()) {
            this.menu.setVisible(false);
        }
        this.menu.show(this, x, y);
    }

    private void updateGroups() {
        List<UiComponent> components = this.getComponents();
        for (int i = 0; i < this.groupIndices.length; ++i) {
            int groupIndex = this.groupIndices[i];
            ToolbarActionGroup group = (ToolbarActionGroup)components.get(groupIndex);
            if (!group.isCustom()) continue;
            int nextGroup = i + 1 < this.groupIndices.length ? this.groupIndices[i + 1] : components.size();
            boolean oneVisible = false;
            int groupLen = nextGroup - groupIndex;
            for (int j = 1; j < groupLen; ++j) {
                int componentIndex = groupIndex + j;
                UiComponent component = components.get(componentIndex);
                CustomAction action = this.getCustomActionFrom(component);
                if (action == null) continue;
                Object value = action.getValue("oracle.bpm.action.custom.visible");
                boolean visible = Boolean.TRUE.equals(value);
                component.setVisible(visible);
                oneVisible = oneVisible || visible;
            }
            if (group.getMode() != 2) continue;
            UiComponent component = components.get(groupIndex + 1);
            component.setVisible(oneVisible);
        }
        this.repaint();
        this.firePropertyChange(ACTIONS_PROPERTY, null, null);
    }

    static class AbstractCustomAction
    extends CustomFuegoAction {
        public AbstractCustomAction(Msg msg) {
            super(msg);
        }

        @Override
        public void run() {
        }
    }
}

