/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.tips;

import java.io.File;
import java.net.URL;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Browser;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tips.TipOfTheDay;
import oracle.bpm.ui.utils.Layout;

class TipOfTheDayDialog
extends Dialog {
    private boolean addPrevious = true;
    private Browser browser;
    private boolean showTips;
    private TipOfTheDay totd;

    private TipOfTheDayDialog(UiWindow parent, File baseDir, boolean showTipsOnStartUp) {
        super(parent, "Tip of the Day", true);
        this.init(baseDir, showTipsOnStartUp);
    }

    @Override
    public void accept() {
        this.nextTip();
    }

    @Override
    public void close() {
        this.totd.storePreferences(this.showTips);
        super.close();
    }

    static TipOfTheDayDialog createTipsDialog(UiWindow frame, File baseDir, boolean showTipsOnStartUp) {
        TipOfTheDayDialog d = new TipOfTheDayDialog(frame, baseDir, showTipsOnStartUp);
        d.setLocationRelativeTo(frame);
        d.currentTip();
        return d;
    }

    private void setPage(URL url) {
        if (url != null) {
            this.browser.setUrl(url);
        }
    }

    private void setSameSizes(Button next, Button close) {
        int w = next.getPreferredSize().getWidth();
        int h = next.getPreferredSize().getHeight();
        if (close.getPreferredSize().getWidth() > w) {
            w = close.getPreferredSize().getWidth();
        }
        if (close.getPreferredSize().getHeight() > h) {
            h = close.getPreferredSize().getHeight();
        }
        Dimension dim = Dimension.valueOf((int)w, (int)h);
        close.setPreferredSize(dim);
        next.setPreferredSize(dim);
    }

    private void currentTip() {
        this.setPage(this.totd.getCurrTip());
    }

    private void init(File baseDir, boolean showTipsOnStartUp) {
        this.showTips = showTipsOnStartUp;
        this.totd = TipOfTheDay.createTips(baseDir);
        BaseAction showTipsAction = new BaseAction(UIMsg.TIP_SHOW){

            @Override
            public void run() {
                TipOfTheDayDialog.this.showTips = !TipOfTheDayDialog.this.showTips;
            }
        };
        BaseAction closeAction = new BaseAction(UIMsg.TIP_CLOSE){

            @Override
            public void run() {
                TipOfTheDayDialog.this.close();
            }
        };
        BaseAction nextAction = new BaseAction(UIMsg.TIP_NEXT_TIP){

            @Override
            public void run() {
                TipOfTheDayDialog.this.nextTip();
            }
        };
        BaseAction prevAction = new BaseAction(UIMsg.TIP_PREVIOUS_TIP){

            @Override
            public void run() {
                TipOfTheDayDialog.this.prevTip();
            }
        };
        UiContainer contentPane = this.getContentPane();
        Panel panel = new Panel(contentPane);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        RelativeLayout relativeLayout = new RelativeLayout();
        panel.setLayout(relativeLayout);
        this.browser = new Browser(panel);
        Label label = Label.create((UiContainer)panel, UIMsg.TIP_HEADER);
        Font font = label.getFont();
        label.setFont(font.larger(3));
        label.setBackground(Color.WHITE);
        panel.add(label, "label");
        panel.add(this.browser, "center");
        CheckBox showTipsCheck = CheckBox.create((UiContainer)panel, showTipsAction);
        showTipsCheck.setSelected(this.showTips);
        panel.add(showTipsCheck, "check");
        Button next = new Button((UiContainer)panel, nextAction);
        next.setDefaultCapable(true);
        this.setDefaultButton(next);
        Button close = new Button((UiContainer)panel, closeAction);
        if (this.addPrevious) {
            Button prev = new Button((UiContainer)panel, prevAction);
            panel.add(prev, "previous");
        }
        panel.add(next, "next");
        panel.add(close, "close");
        this.setSameSizes(next, close);
        Layout.fixToRoot(relativeLayout, "label", AttributeType.TOP);
        Layout.fixToRoot(relativeLayout, "label", AttributeType.LEFT);
        Layout.fixToRoot(relativeLayout, "label", AttributeType.RIGHT);
        Layout.fixToComp(relativeLayout, "center", AttributeType.TOP, "label", AttributeType.BOTTOM, 0);
        Layout.fixToRoot(relativeLayout, "center", AttributeType.LEFT);
        Layout.fixToRoot(relativeLayout, "center", AttributeType.RIGHT);
        Layout.fixToComp(relativeLayout, "center", AttributeType.BOTTOM, "label", AttributeType.BOTTOM, 200);
        relativeLayout.addConstraint("check", AttributeType.LEFT, new AttributeConstraint("center", AttributeType.LEFT));
        relativeLayout.addConstraint("check", AttributeType.TOP, new AttributeConstraint("center", AttributeType.BOTTOM, 5));
        relativeLayout.addConstraint("close", AttributeType.RIGHT, new AttributeConstraint("center", AttributeType.RIGHT));
        relativeLayout.addConstraint("next", AttributeType.RIGHT, new AttributeConstraint("close", AttributeType.LEFT, -5));
        relativeLayout.addConstraint("next", AttributeType.TOP, new AttributeConstraint("close", AttributeType.TOP));
        relativeLayout.addConstraint("next", AttributeType.BOTTOM, new AttributeConstraint("close", AttributeType.BOTTOM));
        relativeLayout.addConstraint("close", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
        if (this.addPrevious) {
            relativeLayout.addConstraint("previous", AttributeType.RIGHT, new AttributeConstraint("next", AttributeType.LEFT, -5));
            relativeLayout.addConstraint("previous", AttributeType.TOP, new AttributeConstraint("close", AttributeType.TOP));
            relativeLayout.addConstraint("previous", AttributeType.BOTTOM, new AttributeConstraint("close", AttributeType.BOTTOM));
        }
        contentPane.setLayout(new BorderLayout());
        contentPane.add(panel, "Center");
        this.pack();
    }

    private void nextTip() {
        this.setPage(this.totd.nextTip());
    }

    private void prevTip() {
        this.setPage(this.totd.prevTip());
    }
}

