/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text.filter;

import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.filter.LimitFilter;
import oracle.bpm.util.StringTokenizer;

public class RGBFilter
extends LimitFilter {
    private TextField textField;
    public static final int RGB_LENGTH = 11;

    public RGBFilter(TextField textField) {
        super(11);
        this.textField = textField;
    }

    @Override
    public boolean accepts(String str, int offs) {
        return super.accepts(str, offs) && this.checkRGB(str, offs);
    }

    @Override
    public String filter(String str, int offs) {
        return str;
    }

    private String getHoleText() {
        return this.textField.getText();
    }

    private boolean checkRGB(String str, int offs) {
        boolean result = true;
        StringBuffer sb = new StringBuffer(this.getHoleText());
        sb.insert(offs, str);
        String text = sb.toString();
        if (!"".equals(text)) {
            StringTokenizer stringTokenizer = new StringTokenizer(text, ",");
            int tokenCount = 0;
            while (stringTokenizer.hasMoreTokens()) {
                if (++tokenCount < 4) {
                    String nextToken = stringTokenizer.nextToken();
                    try {
                        int color = Integer.valueOf(nextToken);
                        if (color >= 0 && color <= 255 && nextToken.length() <= 3) continue;
                        result = false;
                    }
                    catch (NumberFormatException e) {
                        result = false;
                    }
                    continue;
                }
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

