/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.event.Editable;
import oracle.bpm.ui.event.EditorListener;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.TablePeer;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.DefaultTableModel;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableListener;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.ViewerSorter;
import oracle.bpm.ui.table.editors.BooleanCheckBoxCellEditor;
import oracle.bpm.ui.table.editors.NumericFieldCellEditor;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.table.editors.TextFieldCellEditor;
import oracle.bpm.ui.table.renderers.BooleanCheckBoxLabelProvider;
import org.jetbrains.annotations.NotNull;

public class Table
extends UiContainer
implements Editable {
    private ColumnManager columnManager;
    private List<TableListener> listener;
    private List<ModificationListener> modificationListeners = new ArrayList<ModificationListener>();
    private TableModelListener modificationTableModelListener;
    private ListSelectionMode selectionMode;
    private TableModelListener structureChangeTableModelListener;
    protected static final ListSelectionMode DEFAULT_SELECTION_MODE = ListSelectionMode.MULTIPLE_INTERVAL_SELECTION;

    public Table(UiContainer parent) {
        this(parent, null, DEFAULT_SELECTION_MODE);
    }

    public Table(UiContainer parent, ListSelectionMode selectionMode) {
        this(parent, null, selectionMode);
    }

    public Table(UiContainer parent, TableModel tm) {
        this(parent, tm, DEFAULT_SELECTION_MODE);
    }

    public Table(UiContainer parent, TableModel tm, ListSelectionMode selectionMode) {
        super(parent);
        this.selectionMode = selectionMode;
        this.init();
        this.setModel(tm != null ? tm : new DefaultTableModel());
        this.setBackgroundByInheritance();
    }

    protected Table(Peer peer) {
        super(peer);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public void setAutoResizeMode(AutoResizeMode mode) {
        this.getTablePeer().setAutoResizeMode(mode);
    }

    public TableCellEditor getCellEditor() {
        return this.getTablePeer().getCellEditor();
    }

    public TableCellEditor getCellEditor(int row, int column) {
        return this.getTablePeer().getCellEditor(row, column);
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        return this.getTablePeer().getCellRect(row, column, includeSpacing);
    }

    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        this.getTablePeer().setCellSelectionEnabled(cellSelectionEnabled);
    }

    public TableColumn getColumn(int column) {
        return (TableColumn)this.getColumnManager().getColumn(column);
    }

    public int getColumnCount() {
        return this.getTablePeer().getColumnCount();
    }

    public void setColumnHideAllowed(boolean columnHideAllowed) {
        this.getTablePeer().setColumnHideAllowed(columnHideAllowed);
    }

    public String getColumnName(int column) {
        return this.getTablePeer().getColumnName(column);
    }

    public boolean isColumnVisible(int column) {
        return this.getTablePeer().isColumnVisible(column);
    }

    public void setDefaultColorProvider(Class columnClass, ColorProvider provider) {
        this.getTablePeer().setDefaultColorProvider(columnClass, provider);
    }

    public void setDefaultEditor(Class columnClass, TableCellEditor editor) {
        this.getTablePeer().setDefaultEditor(columnClass, editor);
    }

    public TableCellEditor getDefaultEditor(Class columnClass) {
        return this.getTablePeer().getDefaultEditor(columnClass);
    }

    public void setDefaultFontProvider(Class columnClass, FontProvider provider) {
        this.getTablePeer().setDefaultFontProvider(columnClass, provider);
    }

    public void setDefaultLabelProvider(Class columnClass, LabelProvider provider) {
        this.getTablePeer().setDefaultLabelProvider(columnClass, provider);
    }

    public boolean isEditing() {
        return this.getTablePeer().isEditing();
    }

    public int getEditingColumn() {
        return this.getTablePeer().getEditingColumn();
    }

    public int getEditingRow() {
        return this.getTablePeer().getEditingRow();
    }

    public void setHeaderVisible(boolean show) {
        this.getTablePeer().setHeaderVisible(show);
    }

    public boolean isHeaderVisible() {
        return this.getTablePeer().isHeaderVisible();
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        TableModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeTableModelListener(this.getStructureChangeTableModelListener());
        }
        this.getColumnManager().clear();
        this.modificationListeners.clear();
        this.modificationTableModelListener = null;
        tableModel.addTableModelListener(this.getStructureChangeTableModelListener());
        this.getTablePeer().setModel(tableModel);
        if (this.contributesToEdition()) {
            UiUtilities.addToEditableContainer(this, this.getParent());
        }
    }

    public TableModel getModel() {
        return this.getTablePeer().getModel();
    }

    public void setRowHeight(int rowHeight) {
        this.getTablePeer().setRowHeight(rowHeight);
    }

    public void setPreferredRows(int preferredRows) {
        this.getTablePeer().setPreferredRows(preferredRows);
    }

    public void scrollToRow(int row) {
        this.getTablePeer().scrollToRow(row);
    }

    public void setRelativeSizes(@NotNull double[] sizes) {
        double[] normalized;
        double sum = 0.0;
        int len = sizes.length;
        for (int i = 0; i < len; ++i) {
            sum += sizes[i];
        }
        if (sum == 0.0 || sum == 1.0) {
            normalized = sizes;
        } else {
            normalized = new double[len];
            for (int i = 0; i < len; ++i) {
                normalized[i] = sizes[i] / sum;
            }
        }
        this.getTablePeer().setRelativeSizes(normalized);
    }

    public void setReorderingAllowed(boolean reorderingAllowed) {
        this.getTablePeer().setReorderingAllowed(reorderingAllowed);
    }

    public boolean isReorderingAllowed() {
        return this.getTablePeer().isReorderingAllowed();
    }

    public int getRowCount() {
        return this.getTablePeer().getRowCount();
    }

    public int getRowHeight() {
        return this.getTablePeer().getRowHeight();
    }

    public boolean isRowSelected(int row) {
        return this.getTablePeer().isRowSelected(row);
    }

    public int getSelectedColumn() {
        return this.getTablePeer().getSelectedColumn();
    }

    public int getSelectedRow() {
        return this.getTablePeer().getSelectedRow();
    }

    public int getSelectedRowCount() {
        return this.getTablePeer().getSelectedRowCount();
    }

    public int[] getSelectedRows() {
        return this.getTablePeer().getSelectedRows();
    }

    public void setSelectionInterval(int index0, int index1) {
        this.getTablePeer().setSelectionInterval(index0, index1);
    }

    public void setShowGrid(boolean showGrid) {
        this.getTablePeer().setShowGrid(showGrid);
    }

    public void setShowHorizontalLines(boolean showHorizontalLines) {
        this.getTablePeer().setShowHorizontalLines(showHorizontalLines);
    }

    public void setShowVerticalLines(boolean showVerticalLines) {
        this.getTablePeer().setShowVerticalLines(showVerticalLines);
    }

    public final void setValueAt(Object aValue, int row, int column) {
        this.getTablePeer().setValueAt(aValue, row, column);
    }

    public final Object getValueAt(int row, int column) {
        return this.getTablePeer().getValueAt(row, column);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getTablePeer().addListSelectionListener(listener);
    }

    public void addRowSelectionInterval(int index0, int index1) {
        this.getTablePeer().addRowSelectionInterval(index0, index1);
    }

    public void addTableListener(TableListener listener) {
        if (this.listener == null) {
            this.listener = new ArrayList<TableListener>();
        }
        this.listener.add(listener);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.getModel().addTableModelListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.getModel().removeTableModelListener(listener);
    }

    public void clearSelection() {
        this.getTablePeer().clearSelection();
    }

    public int columnAtPoint(Point point) {
        return this.getTablePeer().columnAtPoint(point);
    }

    public final void editCellAt(int row, int column) {
        this.getTablePeer().editCellAt(row, column);
    }

    public void setSorter(ViewerSorter sorter) {
        this.getTablePeer().setSorter(sorter);
    }

    public ViewerSorter getSorter() {
        return this.getTablePeer().getSorter();
    }

    public void addEditorListener(EditorListener listener) {
        this.getTablePeer().addEditorListener(listener);
    }

    public void freezeFirstColumn() {
        this.getTablePeer().freezeFirstColumn();
    }

    public void hideColumn(int column) {
        this.getTablePeer().hideColumn(column);
    }

    public void moveColumn(int column, int targetColumn) {
        this.getTablePeer().moveColumn(column, targetColumn);
    }

    public void notifyRowAdded(int row) {
        this.tableChanged(new TableModelEvent(this.getModel(), row, row, -1, 1));
    }

    public void notifyRowDeleted(int row) {
        this.tableChanged(new TableModelEvent(this.getModel(), row, row, -1, -1));
    }

    public void removeEditorListener(EditorListener listener) {
        this.getTablePeer().removeEditorListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.getTablePeer().removeListSelectionListener(listener);
    }

    public void removeRowSelectionInterval(int index0, int index1) {
        this.getTablePeer().removeRowSelectionInterval(index0, index1);
    }

    public void removeTableListener(TableListener listener) {
        if (this.listener != null) {
            this.listener.remove(listener);
        }
    }

    public int rowAtPoint(Point point) {
        return this.getTablePeer().rowAtPoint(point);
    }

    public void rowChanged(int row) {
        this.tableChanged(new TableModelEvent(this.getModel(), row, row, -1, 0));
    }

    public void showColumn(int column) {
        this.getTablePeer().showColumn(column);
    }

    public void tableChanged(TableModelEvent e) {
        this.getTablePeer().tableChanged(e);
    }

    @Override
    public void translate() {
        Utilities.translateChildComponentTree(this);
    }

    @Override
    public void resetModified() {
        this.modified = false;
    }

    @Override
    public void addModificationListener(ModificationListener listener) {
        this.modificationListeners.add(listener);
        if (this.modificationTableModelListener == null) {
            this.modificationTableModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    Table.this.fireChanged();
                }
            };
            this.addTableModelListener(this.modificationTableModelListener);
        }
    }

    public TableModelListener getStructureChangeTableModelListener() {
        if (this.structureChangeTableModelListener == null) {
            this.structureChangeTableModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getFirstRow() == -1) {
                        Table.this.getColumnManager().clear();
                    }
                }
            };
        }
        return this.structureChangeTableModelListener;
    }

    @Override
    public void removeModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
        if (this.modificationListeners.isEmpty()) {
            this.removeTableModelListener(this.modificationTableModelListener);
            this.modificationTableModelListener = null;
        }
    }

    public void setAutoCreateRowSorter(boolean b) {
        this.getTablePeer().setAutoCreateRowSorter(b);
    }

    protected boolean contributesToEdition() {
        return true;
    }

    protected ListSelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    protected Class getColumnClass(int column) {
        return this.getTablePeer().getColumnClass(column);
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createTable(this.getParentPeer(), this.getSelectionMode(), ScrollPolicy.ALWAYS, ScrollPolicy.AS_NEEDED);
    }

    private void fireChanged() {
        for (ModificationListener modificationListener : this.modificationListeners) {
            modificationListener.objectModified(new ModificationEvent((Object)this, null, null));
        }
    }

    private ColumnManager getColumnManager() {
        if (this.columnManager == null) {
            this.columnManager = new ColumnManager(this);
        }
        return this.columnManager;
    }

    private TablePeer getTablePeer() {
        return (TablePeer)this.getPeer();
    }

    private void addKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Table.this.fireKeyPressed(Table.this, Table.this.getSelectedRow(), e);
            }
        });
    }

    private void addMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                int row = Table.this.rowAtPoint(new Point(e.getX(), e.getY()));
                int col = Table.this.columnAtPoint(new Point(e.getX(), e.getY()));
                if (row != -1 && col != -1) {
                    Table.this.fireDoubleClick(Table.this, row, col, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = Table.this.rowAtPoint(new Point(e.getX(), e.getY()));
                int col = Table.this.columnAtPoint(new Point(e.getX(), e.getY()));
                if (row != -1 && col != -1 && !MouseEventUtilities.isPopupTrigger(e) && e.getClickCount() <= 1) {
                    Table.this.fireSingleClick(Table.this, row, col, e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int col;
                    int row;
                    if (e.getX() == 0 && e.getY() == 0) {
                        row = Table.this.getSelectedRow();
                        col = Table.this.getSelectedColumn();
                        if (row != -1 && col != -1) {
                            Rectangle cellRect = Table.this.getCellRect(row, col, true);
                            e.translatePoint(cellRect.getX(), cellRect.getY());
                        }
                    } else {
                        row = Table.this.rowAtPoint(new Point(e.getX(), e.getY()));
                        col = Table.this.columnAtPoint(new Point(e.getX(), e.getY()));
                    }
                    if (row != -1 && col != -1) {
                        if (!Table.this.isRowSelected(row)) {
                            Table.this.setSelectionInterval(row, row);
                        }
                        Table.this.firePopupTriggered(Table.this, row, col, e);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int col;
                    int row;
                    if (e.getX() == 0 && e.getY() == 0) {
                        row = Table.this.getSelectedRow();
                        col = Table.this.getSelectedColumn();
                        if (row != -1 && col != -1) {
                            Rectangle cellRect = Table.this.getCellRect(row, col, true);
                            e.translatePoint(cellRect.getX(), cellRect.getY());
                        }
                    } else {
                        Point point = new Point(e.getX(), e.getY());
                        row = Table.this.rowAtPoint(point);
                        col = Table.this.columnAtPoint(point);
                    }
                    if (row != -1 && col != -1) {
                        if (!Table.this.isRowSelected(row)) {
                            Table.this.setSelectionInterval(row, row);
                        }
                        Table.this.firePopupTriggered(Table.this, row, col, e);
                    }
                }
            }
        });
    }

    private void fireDoubleClick(Table table, int row, int column, MouseEvent e) {
        if (this.listener != null) {
            for (TableListener aListener : this.listener) {
                aListener.doubleClick(table, row, column, e);
            }
        }
    }

    private void fireKeyPressed(Table table, int row, KeyEvent e) {
        if (this.listener != null) {
            for (TableListener aListener : this.listener) {
                aListener.keyPressed(table, row, e);
            }
        }
    }

    private void firePopupTriggered(Table table, int row, int column, MouseEvent e) {
        if (this.listener != null) {
            for (TableListener aListener : this.listener) {
                aListener.popupTriggered(table, row, column, e);
            }
        }
    }

    private void fireSingleClick(Table table, int row, int column, MouseEvent e) {
        if (this.listener != null) {
            for (TableListener aListener : this.listener) {
                aListener.singleClick(table, row, column, e);
            }
        }
    }

    private void init() {
        this.addKeyListener();
        this.addMouseListener();
        this.initDefaultProviders();
        this.initDefaultEditors();
    }

    private void initDefaultProviders() {
        this.setDefaultLabelProvider(Boolean.class, BooleanCheckBoxLabelProvider.getInstance());
    }

    private void initDefaultEditors() {
        this.setDefaultEditor(Object.class, new TextFieldCellEditor());
        this.setDefaultEditor(Integer.class, NumericFieldCellEditor.createIntegerCellEditor());
        this.setDefaultEditor(Long.class, NumericFieldCellEditor.createLongCellEditor());
        this.setDefaultEditor(Double.class, NumericFieldCellEditor.createDoubleCellEditor());
        this.setDefaultEditor(Float.class, NumericFieldCellEditor.createFloatCellEditor());
        this.setDefaultEditor(Short.class, NumericFieldCellEditor.createShortCellEditor());
        this.setDefaultEditor(BigDecimal.class, NumericFieldCellEditor.createBigDecimalCellEditor());
        this.setDefaultEditor(BigInteger.class, NumericFieldCellEditor.createBigIntegerCellEditor());
        this.setDefaultEditor(Boolean.class, new BooleanCheckBoxCellEditor());
    }

    private static class ColumnManager
    extends oracle.bpm.ui.internal.ColumnManager<TableColumn> {
        public ColumnManager(UiContainer parent) {
            super(parent);
        }

        @Override
        public TableColumn create(UiContainer parent, int columnIndex) {
            return new TableColumn(parent, columnIndex);
        }
    }
}

