/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.selector;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.selector.EditorListener;
import oracle.bpm.ui.selector.Selector;
import oracle.bpm.ui.selector.SelectorEditor;
import oracle.bpm.ui.selector.SelectorItem;
import oracle.bpm.ui.selector.SelectorListener;
import org.jetbrains.annotations.NotNull;

abstract class AbstractSelectorBuilder<K, V> {
    private EditorCardPanel<K, V> editorsPanel;
    private Selector<K> selector;

    AbstractSelectorBuilder() {
    }

    public K getSelectorValue() {
        return this.editorsPanel.getActiveEditor().getSelectorValue();
    }

    public void setSelectorValue(K selectorValue) {
        this.selector.setValue(selectorValue);
    }

    public V getValue() {
        return this.editorsPanel.getActiveEditor().getValue();
    }

    public void setValue(V value) {
        this.editorsPanel.getActiveEditor().setValue(value);
    }

    public void addSelectorListener(SelectorListener listener) {
        this.selector.addListener(listener);
    }

    public void removeSelectorListener(SelectorListener listener) {
        this.selector.removeListener(listener);
    }

    public void addEditorListener(EditorListener listener) {
        this.editorsPanel.addEditorListener(listener);
    }

    public void removeEditorListener(EditorListener listener) {
        this.editorsPanel.removeEditorListener(listener);
    }

    public UiComponent build(UiContainer parent, @NotNull V value) {
        Panel result = new Panel(parent);
        Sequence<SelectorEditor<K, V>> editors = this.createEditors(value);
        result.setLayout(new MigLayout("hidemode 3, ins 0, gap 5, fill"));
        this.selector = this.createSelector(this.createSelectorItems(editors));
        this.selector.addListener(new SelectorListener(){

            @Override
            public void selectorChanged() {
                AbstractSelectorBuilder.this.editorsPanel.show(AbstractSelectorBuilder.this.selector.getValue());
            }
        });
        this.editorsPanel = new EditorCardPanel<K, V>((UiContainer)result, editors);
        result.add(this.selector.getUiComponent(result));
        result.add(this.editorsPanel, "pushx, growx, wrap");
        this.selector.setValue(this.getDefaultSelection(value));
        return result;
    }

    protected abstract Selector<K> createSelector(Sequence<SelectorItem<K>> var1);

    protected abstract Sequence<SelectorEditor<K, V>> createEditors(V var1);

    protected abstract K getDefaultSelection(V var1);

    private Sequence<SelectorItem<K>> createSelectorItems(@NotNull Sequence<SelectorEditor<K, V>> editors) {
        ArrayList result = new ArrayList();
        for (SelectorEditor editor : editors) {
            SelectorItem item = SelectorItem.create(editor.getSelectorValue(), editor.getIcon(), editor.getLabel());
            result.add(item);
        }
        return CollectionUtils.asSequence(result);
    }

    private static class EditorCardPanel<K, V>
    extends Panel {
        private SelectorEditor<K, V> activeEditor;
        private Sequence<SelectorEditor<K, V>> editors;
        private List<EditorListener> listeners = new ArrayList<EditorListener>();

        public EditorCardPanel(UiContainer parent, Sequence<SelectorEditor<K, V>> editors) {
            super(parent);
            this.editors = editors;
            this.init();
        }

        @Override
        public CardLayout getLayout() {
            return (CardLayout)super.getLayout();
        }

        public void show(K selectorValue) {
            SelectorEditor<K, V> editor = this.findEditor(selectorValue);
            EditorListener delegateEditorListener = new EditorListener(){

                @Override
                public void editorChanged() {
                    EditorCardPanel.this.fireEditorChanged();
                }
            };
            if (editor != this.activeEditor) {
                String key = editor.getLabel();
                if (!this.getLayout().contains(key)) {
                    UiComponent uiComponent = editor.getUiComponent(this);
                    editor.addEditorListener(delegateEditorListener);
                    this.add(uiComponent, key);
                }
                this.getLayout().show(this, key);
                this.activeEditor = editor;
            }
        }

        public SelectorEditor<K, V> getActiveEditor() {
            return this.activeEditor;
        }

        public void addEditorListener(EditorListener listener) {
            this.listeners.add(listener);
        }

        public void removeEditorListener(EditorListener listener) {
            this.listeners.remove(listener);
        }

        private void init() {
            this.setLayout(new CardLayout());
            Object defaultValue = ((SelectorEditor)this.editors.iterator().next()).getSelectorValue();
            this.show(defaultValue);
        }

        private SelectorEditor<K, V> findEditor(K selectorValue) {
            SelectorEditor result = null;
            for (SelectorEditor editor : this.editors) {
                if (!editor.getSelectorValue().equals(selectorValue)) continue;
                result = editor;
                break;
            }
            return result;
        }

        private void fireEditorChanged() {
            for (EditorListener listener : this.listeners) {
                listener.editorChanged();
            }
        }
    }
}

