/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.selection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.bpm.lang.Platform;
import oracle.bpm.ui.selection.Selection;

public class DefaultSelection
implements Selection {
    protected List all = Collections.emptyList();
    public static final Selection EMPTY = new DefaultSelection();

    public static Selection createSingle(Object element) {
        Selection result;
        if (element == null) {
            result = EMPTY;
        } else {
            DefaultSelection selection = new DefaultSelection();
            selection.setAll(Collections.singletonList(element));
            result = selection;
        }
        return result;
    }

    public static Selection createMultipleSingle(Selection selection, Object ... elements) {
        Selection result;
        if (selection == null) {
            result = DefaultSelection.createMultiple(elements);
        } else if (elements == null) {
            result = selection;
        } else {
            DefaultSelection newSelection = new DefaultSelection();
            ArrayList<Object> all = new ArrayList<Object>();
            all.addAll(Arrays.asList(elements));
            all.addAll(selection.asList(Object.class));
            newSelection.setAll(all);
            result = selection;
        }
        return result;
    }

    public static Selection createMultiple(List<?> elements) {
        DefaultSelection selection = new DefaultSelection();
        selection.setAll(elements);
        return selection;
    }

    public static Selection createMultiple(Object ... elements) {
        DefaultSelection selection = new DefaultSelection();
        selection.setAll(Arrays.asList(elements));
        return selection;
    }

    @Override
    public boolean isEmpty() {
        return this.getAll().isEmpty();
    }

    @Override
    public boolean isMultiple() {
        return this.getAll().size() > 1;
    }

    @Override
    public boolean isSingle() {
        return this.getAll().size() == 1;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int size() {
        return this.getAll().size();
    }

    @Override
    public <T> T as(Class<T> type) {
        T result = null;
        List elements = this.getAll();
        if (elements.size() > 0) {
            Object first = elements.get(0);
            result = this.convertTo(first, type);
        }
        return result;
    }

    @Override
    public <T> List<T> asList(Class<T> type) {
        List result;
        List elements = this.getAll();
        if (elements.isEmpty()) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            for (Object element : elements) {
                result.add(this.convertTo(element, type));
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.all == null ? 0 : ((Object)this.all).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSelection other = (DefaultSelection)obj;
        return !(this.all == null ? other.all != null : !((Object)this.all).equals(other.all));
    }

    protected void setAll(List all) {
        this.all = all;
    }

    protected List getAll() {
        return this.all;
    }

    protected <T> T convertTo(Object first, Class<T> type) {
        Object result = type.isInstance(first) ? type.cast(first) : Platform.getAdapterService().adaptTo(first, type);
        return result;
    }
}

