/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.CellEditorListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.ResetableProperty;
import oracle.bpm.ui.prop.impl.AbstractEditor;

public class ResetPropertyEditor
extends AbstractEditor {
    private PropertyEditor innerPropertyEditor;
    private boolean reset = false;

    public ResetPropertyEditor(PropertyEditor propertyEditor) {
        this.innerPropertyEditor = propertyEditor;
        propertyEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                ResetPropertyEditor.this.cancelCellEditing();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                ResetPropertyEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.reset ? ((ResetableProperty)((Object)this.getProperty())).getDefaultValue() : this.innerPropertyEditor.getCellEditorValue();
    }

    @Override
    public UiComponent getEditor(UiContainer parent) {
        Property property = this.getProperty();
        Panel newEditor = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        newEditor.setLayout(layout);
        UiComponent innerEditor = this.innerPropertyEditor.createEditor(newEditor, property);
        Button button = new Button(newEditor);
        button.setAction(new BaseAction(UIMsg.CLEAR_VALUE){

            @Override
            public void run() {
                ResetPropertyEditor.this.resetProperty();
            }
        });
        button.setOptions(10);
        Dimension size = Dimension.valueOf((int)button.getIcon().getIconWidth(), (int)button.getIcon().getIconHeight());
        button.setExactSize(size);
        button.setFocusable(false);
        button.setSize(size);
        newEditor.add(innerEditor, "editor");
        newEditor.add(button, "button");
        this.layoutComponents(layout);
        newEditor.setBackground(innerEditor.getBackground());
        newEditor.setOpaque(false);
        return newEditor;
    }

    private void layoutComponents(RelativeLayout layout) {
        layout.addConstraint("editor", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("editor", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("editor", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
        layout.addConstraint("editor", AttributeType.RIGHT, new AttributeConstraint("button", AttributeType.LEFT));
        layout.addConstraint("button", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -1));
        layout.addConstraint("button", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("button", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
        layout.addConstraint("button", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.HEIGHT));
    }

    private void resetProperty() {
        Property property = this.getProperty();
        if (property instanceof ResetableProperty) {
            this.reset = true;
            this.stopCellEditing();
            this.reset = false;
        }
    }
}

