/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.WindowAdapter;
import oracle.bpm.ui.event.WindowEvent;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.prop.impl.TrimmedTextField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.utils.Layout;

public class LongTextPropertyEditor
extends AbstractEditor {
    private TrimmedTextField field;

    @Override
    public Object getCellEditorValue() {
        return this.field.getFullText();
    }

    @Override
    protected UiComponent getEditor(UiContainer parent) {
        return this.createEditor(parent);
    }

    private Panel createEditor(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        mainPanel.setLayout(layout);
        mainPanel.setOpaque(false);
        mainPanel.setBorder(null);
        mainPanel.setFocusCycleRoot(true);
        final Button triggerButton = new Button(mainPanel);
        triggerButton.setAction(new BaseAction(UIMsg.TO_MSG("...")){

            @Override
            public void run() {
                LongTextPropertyEditor.this.showPopUpText(triggerButton);
            }
        });
        triggerButton.setDefaultCapable(false);
        triggerButton.setFocusPainted(false);
        this.field = new TrimmedTextField(mainPanel);
        this.field.setBorder(null);
        this.field.setEditable(false);
        this.field.setOpaque(false);
        Object value = this.getProperty().getValue();
        String text = value == null ? "" : value.toString();
        this.field.setText(text);
        this.field.requestFocus();
        this.field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    LongTextPropertyEditor.this.showPopUpText(triggerButton);
                }
            }
        });
        this.field.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LongTextPropertyEditor.this.showPopUpText(triggerButton);
                }
            }
        });
        mainPanel.add(this.field, "field");
        mainPanel.add(triggerButton, "button");
        this.layoutComponents(layout);
        return mainPanel;
    }

    private void showPopUpText(UiComponent component) {
        PopUpText popup = new PopUpText(component);
        popup.show(component);
    }

    private void layoutComponents(RelativeLayout layout) {
        Layout.fixToRoot(layout, "button", AttributeType.RIGHT);
        Layout.fixToRoot(layout, "button", AttributeType.TOP);
        Layout.fixToRoot(layout, "button", AttributeType.BOTTOM);
        layout.addConstraint("button", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.HEIGHT));
        layout.addConstraint("field", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("field", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
        layout.addConstraint("field", AttributeType.RIGHT, new AttributeConstraint("button", AttributeType.LEFT, -1));
        layout.addConstraint("field", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 1));
    }

    private class PopUpText
    extends PopUpWindow {
        public PopUpText(UiComponent parent) {
            super(parent.getOwnerWindow());
            this.init();
        }

        private void init() {
            final TextArea area = new TextArea(this);
            String text = LongTextPropertyEditor.this.field.getFullText();
            area.setText(text);
            area.setCaretPosition(text != null ? text.length() : 0);
            area.setRows(4);
            area.setColumns(30);
            area.setWrapStyleWord(true);
            area.setLineWrap(true);
            area.moveCaretPosition(text.length() - 1);
            area.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isControl() && e.isEnter()) {
                        PopUpText.this.setVisible(false);
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    LongTextPropertyEditor.this.field.setText(area.getText());
                }
            });
            this.setPreferredSize(Dimension.valueOf((int)200, (int)150));
            this.add(area);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    LongTextPropertyEditor.this.stopCellEditing();
                }
            });
        }
    }
}

