/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import java.beans.PropertyChangeEvent;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.EditorFactory;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.RendererFactory;

public class BorderProperty
extends PropertyGroup {
    private AbstractProperty borderColorProp;
    private AbstractProperty borderStyleProp;
    private AbstractProperty borderWidthProp;

    public BorderProperty(Msg key, String borderStyle, int borderWidth, String borderColor) {
        this(key, BorderStyle.valueOf((String)borderStyle), borderWidth, borderColor);
    }

    public BorderProperty(Msg key, BorderStyle borderStyle, int borderWidth, String borderColor) {
        super(key);
        this.borderStyleProp = Factory.createBorderStyleCombo(UIMsg.BORDER_STYLE, borderStyle);
        this.borderWidthProp = Factory.createIntegerNumber(UIMsg.BORDER_WIDTH, borderWidth, 0, 20, 1);
        Color col = null;
        if (borderColor != null && !borderColor.trim().equals("") && borderColor.charAt(0) == '#' && borderColor.length() == 7) {
            col = Color.decode(borderColor);
        }
        this.borderColorProp = Factory.createColor(UIMsg.BORDER_COLOR, col);
        this.add(this.borderStyleProp);
        this.add(this.borderWidthProp);
        this.add(this.borderColorProp);
        super.setValue(this.getTextValue());
        this.setPropertyRenderer(RendererFactory.DEFAULT_RENDERER);
        this.setPropertyEditor(EditorFactory.TEXT_EDITOR);
    }

    public AbstractProperty getBorderColorProp() {
        return this.borderColorProp;
    }

    public AbstractProperty getBorderStyleProp() {
        return this.borderStyleProp;
    }

    public AbstractProperty getBorderWidthProp() {
        return this.borderWidthProp;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.setValue(this.getTextValue());
        evt = new PropertyChangeEvent(this, this.getKey(), this.getOldValue(), this.getValue());
        super.propertyChange(evt);
    }

    private String getTextValue() {
        String textValue = null;
        Object styleValue = this.borderStyleProp.getValue();
        if (styleValue == Property.NULL_VALUE || styleValue == null) {
            textValue = "";
        } else if (styleValue instanceof BorderStyle) {
            textValue = ((BorderStyle)styleValue).getString();
            textValue = textValue + ", " + this.borderWidthProp.getValue();
            Object value = this.borderColorProp.getValue();
            if (value != Property.NULL_VALUE && value != null) {
                Color color = (Color)value;
                textValue = textValue + ", [ r=" + color.getRed() + ", g=" + color.getGreen() + ", b=" + color.getBlue() + " ]";
            }
        }
        return textValue;
    }
}

