/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;

public class PropertyGroup
extends AbstractProperty
implements PropertyChangeListener {
    private List<Property> children = new ArrayList<Property>();
    private List<Listener> groupListeners;

    public PropertyGroup(String key) {
        this.key = key;
        this.setValue("");
        this.setEditable(false);
    }

    public PropertyGroup(Msg key) {
        this(key.getString());
        this.msgKey = key;
    }

    PropertyGroup(Property property) {
        if (property.getMsg() != null) {
            this.key = property.getMsg().getString();
            this.msgKey = property.getMsg();
        } else {
            this.key = property.getKey();
        }
        this.setValue("");
        this.setEditable(false);
    }

    public int getCount() {
        return this.children.size();
    }

    public void add(Property property) {
        this.add(property, this.getCount());
    }

    public void add(Property property, int index) {
        AbstractProperty abstractProperty = (AbstractProperty)property;
        this.children.add(index, abstractProperty);
        abstractProperty.putClientProperty("state", "initial");
        abstractProperty.putClientProperty("expand", "false");
        abstractProperty.setParent(this);
        abstractProperty.addPropertyChangeListener(this);
        this.firePropertyAdded(this, property, index);
    }

    public void addListener(Listener listener) {
        if (this.groupListeners == null) {
            this.groupListeners = new ArrayList<Listener>();
        }
        this.groupListeners.add(listener);
    }

    public Property get(int index) {
        return this.children.get(index);
    }

    public List<Property> getChildren() {
        return this.children;
    }

    public int indexOf(Property property) {
        return this.children.indexOf(property);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyCheck(this, (Property)evt.getSource());
        this.firePropertyChanged(evt);
    }

    public void propertyCollapsed() {
    }

    public void propertyExpanded() {
    }

    public boolean remove(Property property) {
        int childCount = this.children.size();
        if (childCount == 0) {
            return false;
        }
        boolean result = this.children.remove(property);
        if (result) {
            property.dispose();
            this.firePropertyRemoved(this, property);
        }
        return result;
    }

    public void remove(int index) {
        int childCount = this.children.size();
        if (childCount == 0) {
            return;
        }
        Property property = this.get(index);
        if (property != null) {
            this.remove(property);
        }
    }

    public void removeAll() {
        for (Property property : this.children) {
            property.dispose();
        }
        this.children.clear();
    }

    public void removeListener(Listener listener) {
        if (this.groupListeners == null) {
            return;
        }
        this.groupListeners.remove(listener);
    }

    @Override
    public void dispose() {
        for (Property child : this.children) {
            child.dispose();
        }
    }

    protected void firePropertyCheck(PropertyGroup group, Property property) {
        if (this.groupListeners == null) {
            return;
        }
        for (Listener listener : this.groupListeners) {
            listener.checkProperty(group, property);
        }
    }

    private void firePropertyAdded(PropertyGroup group, Property property, int index) {
        if (this.groupListeners == null) {
            return;
        }
        for (Listener listener : this.groupListeners) {
            listener.propertyAdded(group, property, index);
        }
    }

    private void firePropertyRemoved(PropertyGroup group, Property property) {
        if (this.groupListeners == null) {
            return;
        }
        for (Listener listener : this.groupListeners) {
            listener.propertyRemoved(group, property);
        }
    }

    public static interface Listener {
        public void checkProperty(PropertyGroup var1, Property var2);

        public void propertyAdded(PropertyGroup var1, Property var2, int var3);

        public void propertyRemoved(PropertyGroup var1, Property var2);
    }
}

