/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.plaf.fuego;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolTipUI;
import oracle.bpm.draw.Font;
import oracle.bpm.ui.MultiLineToolTip;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.text.TextArea;

public class FuegoMultiLineToolTipUI
extends MetalToolTipUI {
    protected CellRendererPane rendererPane;
    protected Font smallFont;
    private static TextArea textArea;
    static FuegoMultiLineToolTipUI sharedInstance;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.isMultiLine(c)) {
            String tipText = ((JToolTip)c).getTipText();
            if (tipText == null || this.rendererPane == null) {
                return new Dimension(0, 0);
            }
            textArea = new TextArea((UiContainer)null);
            textArea.setText(tipText);
            textArea.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.rendererPane.removeAll();
            this.rendererPane.add(textArea.asSwing());
            textArea.setWrapStyleWord(true);
            int width = this.getFixedWidth(c);
            int columns = this.getColumns(c);
            if (columns > 0) {
                textArea.setColumns(columns);
                textArea.setSize(0, 0);
                textArea.setLineWrap(true);
                textArea.setSize(textArea.getPreferredSize());
            } else if (width > 0) {
                textArea.setLineWrap(true);
                oracle.bpm.geom.Dimension d = textArea.getPreferredSize();
                d = oracle.bpm.geom.Dimension.valueOf((int)d.getWidth(), (int)(d.getHeight() + 1));
                textArea.setSize(d);
            } else {
                textArea.setLineWrap(false);
            }
            oracle.bpm.geom.Dimension dim = textArea.getPreferredSize();
            return new Dimension(dim.getWidth() + 1, dim.getHeight() + 1);
        }
        return super.getPreferredSize(c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (this.isMultiLine(c)) {
            this.rendererPane = new CellRendererPane();
            c.add(this.rendererPane);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.isMultiLine(c)) {
            oracle.bpm.geom.Dimension size = UiComponent.get(c).getSize();
            textArea.setBackground(AwtConverter.fromAwt(c.getBackground()));
            this.rendererPane.paintComponent(g, textArea.asSwing(), c, 1, 1, size.getWidth() - 1, size.getHeight() - 1, true);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.isMultiLine(c)) {
            super.uninstallUI(c);
            if (this.rendererPane != null) {
                c.remove(this.rendererPane);
                this.rendererPane = null;
            }
        }
    }

    private int getColumns(JComponent c) {
        if (c instanceof MultiLineToolTip) {
            return ((MultiLineToolTip)c).getColumns();
        }
        Object property = c.getClientProperty("oracle.bpm.laf.tooltip.columns");
        if (property != null && property instanceof Integer) {
            return (Integer)property;
        }
        return 0;
    }

    private int getFixedWidth(JComponent c) {
        if (c instanceof MultiLineToolTip) {
            return ((MultiLineToolTip)c).getFixedWidth();
        }
        Object property = c.getClientProperty("oracle.bpm.laf.tooltip.width");
        if (property != null && property instanceof Integer) {
            return (Integer)property;
        }
        return 0;
    }

    private boolean isMultiLine(JComponent c) {
        Object property;
        boolean isMultiLine = c instanceof MultiLineToolTip;
        if (!isMultiLine && (property = c.getClientProperty("oracle.bpm.laf.tooltip.multiline")) != null && property.equals(Boolean.TRUE)) {
            isMultiLine = true;
        }
        return isMultiLine;
    }

    static {
        sharedInstance = new FuegoMultiLineToolTipUI();
    }
}

