/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.interval;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.text.Document;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.interval.CalendarChooser;
import oracle.bpm.ui.peer.swing.interval.ExtendedTimeField;
import oracle.bpm.ui.peer.swing.interval.SpinnerGUI;
import oracle.bpm.ui.peer.swing.interval.TimeIntervalField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;

class TimeFieldGUI
extends SpinnerGUI
implements ActionListener,
FocusListener,
KeyListener {
    protected transient CalendarButtonListener calendarButtonListener_d;
    protected transient PropertyChangeListener propertyChangedListener_d;
    protected transient ValueChangedListener valueChangedListener_d = this.createValueChangedListener();
    private JButton calendarButton_d;
    private JDialog dialog_d;
    private boolean isCalendarDialogShowing_d = false;
    private transient String savedText_d;
    private static final long serialVersionUID = 6933247749139012144L;

    public TimeFieldGUI(JComponent jcomponent) {
        super(jcomponent);
        this.propertyChangedListener_d = this.createPropertyChangeListener();
        this.installListeners(jcomponent);
        this.initTextField();
    }

    public void setDialog(JDialog d) {
        this.dialog_d = d;
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        if (!this.getField().getText().equals(this.textField.getText())) {
            this.getField().setText(this.textField.getText());
            this.textField.setText(this.getField().getText());
        }
    }

    @Override
    public void addButtons() {
        if (!TimeField.Style.DATE.equals((Object)this.getField().getType()) && !TimeField.Style.DATE_TIME.equals((Object)this.getField().getType())) {
            super.addButtons();
        } else {
            ImageIcon icon = Image.create(UIMsg.CALENDAR).asSwingImageIcon();
            this.calendarButton_d = new JButton((Icon)icon){
                private static final long serialVersionUID = 0L;

                @Override
                public boolean isFocusable() {
                    return false;
                }
            };
            this.calendarButton_d.setBorder(new BevelBorder(0));
            this.calendarButton_d.setBorderPainted(true);
            this.calendarButton_d.setPreferredSize(new Dimension(icon.getIconWidth() + 4, icon.getIconHeight()));
            this.calendarButtonListener_d = new CalendarButtonListener(this.calendarButton_d);
            if (this.calendarButton_d != null) {
                this.calendarButton_d.addActionListener(this.calendarButtonListener_d);
            }
            this.panel_d.setLayout(new GridLayout(1, 2, 0, 0));
            Box box = Box.createVerticalBox();
            box.add(this.incrButton);
            box.add(this.decrButton);
            this.panel_d.add(box);
            this.panel_d.add(this.calendarButton_d);
            this.spinner.add((Component)this.panel_d, "East");
        }
    }

    public void enableCalendar(boolean enable) {
        if (this.calendarButton_d != null) {
            this.calendarButton_d.setVisible(enable);
        }
    }

    @Override
    public void focusGained(FocusEvent focusevent) {
        this.textField.setCaretPosition(this.textField.getText().length());
        this.textField.moveCaretPosition(0);
    }

    @Override
    public void focusLost(FocusEvent focusevent) {
        this.textField.postActionEvent();
    }

    @Override
    public void keyPressed(KeyEvent keyevent) {
        if (!keyevent.isActionKey()) {
            if (this.getField().isRequired()) {
                this.savedText_d = this.textField.getText();
            }
        } else {
            this.setCaretPos(this.textField.getCaretPosition());
            switch (keyevent.getKeyCode()) {
                case 38: {
                    this.fixValue();
                    this.getField().scrollUp();
                    keyevent.consume();
                    break;
                }
                case 40: {
                    this.fixValue();
                    this.getField().scrollDown();
                    keyevent.consume();
                    break;
                }
                case 39: {
                    this.fixValue();
                    this.getField().advanceField(1);
                    this.selectCurrentField();
                    keyevent.consume();
                    break;
                }
                case 37: {
                    this.fixValue();
                    this.getField().advanceField(-1);
                    this.selectCurrentField();
                    keyevent.consume();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyevent) {
    }

    @Override
    public void keyTyped(KeyEvent keyevent) {
        boolean del;
        if (this.savedText_d != null && "".equals(this.textField.getText())) {
            this.textField.setText(this.savedText_d);
            this.savedText_d = null;
            this.textField.setCaretPosition(this.textField.getText().length());
            this.textField.moveCaretPosition(0);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        boolean bl = del = keyevent.getKeyChar() == ' ';
        if (this.textField.getText().equals(this.textField.getSelectedText())) {
            if (!del || !this.getField().isRequired()) {
                this.textField.setText("");
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            if (del) {
                keyevent.consume();
            }
        }
    }

    protected TimeIntervalField getField() {
        return (TimeIntervalField)this.spinner;
    }

    protected void addFocusListener(final FocusListener fl) {
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                fl.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!(TimeFieldGUI.this.calendarButton_d != null && TimeFieldGUI.this.calendarButton_d.hasFocus() || TimeFieldGUI.this.isCalendarDialogShowing_d || TimeFieldGUI.this.incrButton.hasFocus() || TimeFieldGUI.this.decrButton.hasFocus())) {
                    fl.focusLost(e);
                }
            }
        });
        if (this.calendarButton_d != null) {
            this.calendarButton_d.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    fl.focusGained(e);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!(TimeFieldGUI.this.textField.hasFocus() || TimeFieldGUI.this.isCalendarDialogShowing_d || TimeFieldGUI.this.incrButton.hasFocus() || TimeFieldGUI.this.decrButton.hasFocus())) {
                        fl.focusLost(e);
                    }
                }
            });
        }
        this.incrButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                fl.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!(TimeFieldGUI.this.textField.hasFocus() || TimeFieldGUI.this.calendarButton_d != null && TimeFieldGUI.this.calendarButton_d.hasFocus() || TimeFieldGUI.this.isCalendarDialogShowing_d || TimeFieldGUI.this.decrButton.hasFocus())) {
                    fl.focusLost(e);
                }
            }
        });
        this.decrButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                fl.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!(TimeFieldGUI.this.textField.hasFocus() || TimeFieldGUI.this.calendarButton_d != null && TimeFieldGUI.this.calendarButton_d.hasFocus() || TimeFieldGUI.this.isCalendarDialogShowing_d || TimeFieldGUI.this.incrButton.hasFocus())) {
                    fl.focusLost(e);
                }
            }
        });
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertychangeevent) {
                String s = propertychangeevent.getPropertyName();
                boolean setCaret = true;
                if ("orientation".equals(s)) {
                    TimeFieldGUI.this.removeButtons();
                    TimeFieldGUI.this.addButtons();
                    setCaret = false;
                } else if ("dateString".equals(s)) {
                    TimeFieldGUI.this.textField.setText(TimeFieldGUI.this.getField().getText());
                } else if ("formatString".equals(s)) {
                    TimeFieldGUI.this.textField.setText(TimeFieldGUI.this.getField().getText());
                } else if ("date".equals(s)) {
                    TimeFieldGUI.this.textField.setText(TimeFieldGUI.this.getField().getText());
                } else if ("formattingStyle".equals(s)) {
                    TimeFieldGUI.this.textField.setText(TimeFieldGUI.this.getField().getText());
                } else {
                    setCaret = false;
                }
                if (setCaret) {
                    Document doc = TimeFieldGUI.this.textField.getDocument();
                    if (doc != null && doc.getLength() < TimeFieldGUI.this.caretPos) {
                        TimeFieldGUI.this.caretPos = doc.getLength();
                    }
                    TimeFieldGUI.this.textField.setCaretPosition(TimeFieldGUI.this.caretPos);
                }
            }
        };
    }

    protected ValueChangedListener createValueChangedListener() {
        return new ValueChangedListener(){

            @Override
            public void valueChanged(ValueChangedEvent event) {
                TimeFieldGUI.this.textField.setText(TimeFieldGUI.this.getField().getText());
                if (TimeFieldGUI.this.textField.hasFocus()) {
                    TimeFieldGUI.this.selectCurrentField();
                }
            }
        };
    }

    protected void installListeners(JComponent jcomponent) {
        this.getField().addValueChangedListener(this.valueChangedListener_d);
        this.getField().addPropertyChangeListener(this.propertyChangedListener_d);
    }

    void setCaretPos(int i) {
        this.caretPos = i;
        this.textField.setCaretPosition(i);
    }

    int getCaretPos() {
        return this.caretPos;
    }

    private void fixValue() {
        if (!this.getField().getText().equals(this.textField.getText())) {
            this.getField().setText(this.textField.getText());
            this.textField.setText(this.getField().getText());
        }
    }

    private void initTextField() {
        this.textField.setText(this.getField().getText());
        this.textField.setCaretPosition(this.caretPos);
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
    }

    private void selectCurrentField() {
        this.textField.setSelectionStart(this.getField().getFieldStart());
        this.textField.setSelectionEnd(this.getField().getFieldEnd());
    }

    private class CalendarButtonListener
    implements ActionListener {
        private Component parent_d;

        CalendarButtonListener(Component parent) {
            this.parent_d = parent;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JDialog dialog;
            TimeFieldGUI.this.isCalendarDialogShowing_d = true;
            TimeFieldGUI.this.textField.postActionEvent();
            if (TimeFieldGUI.this.dialog_d == null) {
                dialog = new JDialog();
                dialog.setModal(this.parent_d != null);
            } else {
                dialog = new JDialog((Dialog)TimeFieldGUI.this.dialog_d, true);
            }
            CalendarChooser calendarChooser = new CalendarChooser((ExtendedTimeField)TimeFieldGUI.this.getField());
            dialog.getContentPane().add(calendarChooser);
            int titleBar = this.getTitleBarHeight();
            Point adjustedPoint = this.adjustLocationToFitScreen(calendarChooser.getWidth(), calendarChooser.getHeight() + titleBar);
            int x = (int)adjustedPoint.getX();
            int y = (int)adjustedPoint.getY();
            dialog.setLocation(x, y);
            dialog.pack();
            dialog.setResizable(false);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent we) {
                    TimeFieldGUI.this.isCalendarDialogShowing_d = false;
                }
            });
            this.addCancelByEscapeKey(dialog);
            dialog.setVisible(true);
        }

        private void addCancelByEscapeKey(final JDialog dialog) {
            KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
            AbstractAction escapeAction = new AbstractAction(){
                private static final long serialVersionUID = 7833016144345667370L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                }
            };
            dialog.getRootPane().getInputMap(2).put(escape, "ESCAPE");
            dialog.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        }

        private int getTitleBarHeight() {
            JDialog d = new JDialog();
            d.pack();
            return d.getInsets().top;
        }

        private Point adjustLocationToFitScreen(int componentWidth, int componentHeight) {
            int maxYLocation;
            GraphicsConfiguration gc = this.parent_d.getGraphicsConfiguration();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int componentXLocation = (int)this.parent_d.getLocationOnScreen().getX();
            int componentYLocation = (int)this.parent_d.getLocationOnScreen().getY();
            int taskbar = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)gc).bottom;
            int maxXLocation = (int)(screenSize.getWidth() - (double)componentWidth);
            if (componentXLocation > maxXLocation) {
                componentXLocation = maxXLocation;
            }
            if (componentYLocation > (maxYLocation = (int)(screenSize.getHeight() - (double)taskbar - (double)componentHeight))) {
                componentYLocation = maxYLocation;
            }
            return new Point(componentXLocation, componentYLocation);
        }
    }
}

