/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.interval;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import oracle.bpm.lang.Time;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.peer.swing.interval.ExtendedTimeField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;

class CalendarChooser
extends JPanel
implements ActionListener,
MouseListener,
ValueChangedListener {
    Calendar calendar_d;
    String dateFormatString;
    DateFormatSymbols dateFormatSymbols_d;
    transient BasicArrowButton decrementMonth;
    transient BasicArrowButton decrementYear;
    Font fontBold_d;
    Font fontPlain_d;
    int halfXWidth_d;
    transient BasicArrowButton incrementMonth;
    transient BasicArrowButton incrementYear;
    SimpleDateFormat monthLabel_d;
    ExtendedTimeField timeField_d;
    ExtendedTimeField timeSpinner_d;
    TimeZone timeZone_d;
    Time today_d;
    int[][] valid_d;
    int xWidth_d;
    private static final int HEIGHT = 165;
    private static final int WIDTH = 216;
    private static final int TIME_SPINNER_HEIGHT = 23;
    private static final int VARROW_WIDTH = 15;
    private static final int VARROW_HEIGTH = 8;
    private static final int HARROW_WIDTH = 20;
    private static final int HARROW_HEIGTH = 15;
    private static final int MARGIN = 5;
    private static final int ROW_HEIGTH = 12;
    private static final long serialVersionUID = 0L;

    public CalendarChooser(ExtendedTimeField timeField) {
        this.timeField_d = timeField;
        Calendar c = timeField.getCalendar();
        Calendar calendar = this.calendar_d = c != null ? (Calendar)c.clone() : new GregorianCalendar(this.timeField_d.getTimeZone(), this.timeField_d.getLocale());
        if (TimeField.Style.DATE_TIME.equals((Object)this.timeField_d.getType())) {
            this.timeSpinner_d = new ExtendedTimeField(TimeField.Style.TIME, TimeField.Format.DEFAULT, null, Locale.getDefault());
            this.timeSpinner_d.setTime(Time.valueOf((Calendar)this.calendar_d));
            this.timeSpinner_d.addValueChangedListener(this);
        }
        this.dateFormatSymbols_d = new DateFormatSymbols(timeField.getLocale());
        this.monthLabel_d = new SimpleDateFormat("MMMM yyyy", this.timeField_d.getLocale());
        this.today_d = Time.now();
        this.xWidth_d = 30;
        this.halfXWidth_d = 15;
        this.valid_d = new int[6][7];
        for (int j = 0; j < 6; ++j) {
            for (int i = 0; i < 7; ++i) {
                this.valid_d[j][i] = 0;
            }
        }
        this.fontBold_d = new Font("Dialog", 1, 12);
        this.fontPlain_d = new Font("Dialog", 0, 10);
        this.setBorder(new BevelBorder(0));
        this.setSize(this.getPreferredSize());
        this.setLayout(null);
        this.addMouseListener(this);
        this.initialize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int i = 165;
        if (this.timeSpinner_d == null) {
            i -= 23;
        }
        int j = 216;
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            i += insets.top + insets.bottom;
            j += insets.left + insets.right;
        }
        return new Dimension(j, i);
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == this.decrementYear) {
            this.calendar_d.add(1, -1);
            this.paint(this.getGraphics());
        } else if (obj == this.incrementYear) {
            this.calendar_d.add(1, 1);
            this.paint(this.getGraphics());
        } else if (obj == this.decrementMonth) {
            this.calendar_d.add(2, -1);
            this.paint(this.getGraphics());
        } else if (obj == this.incrementMonth) {
            this.calendar_d.add(2, 1);
            this.paint(this.getGraphics());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        int k = i - 10;
        int l = j - 54 + 6;
        if ((k /= this.xWidth_d) < 0 || k > 6 || (l /= 12) < 0 || l > 5) {
            if (j >= this.getSize().height - 18) {
                this.calendar_d.setTime(this.today_d.dateValue());
                this.timeField_d.setTime(this.today_d);
                if (this.timeSpinner_d != null) {
                    this.timeSpinner_d.setTime(this.today_d);
                }
                this.repaint();
            }
            return;
        }
        int day = this.valid_d[l][k];
        if (day != 0) {
            this.calendar_d.set(5, day);
            this.timeField_d.setJavaDate(this.calendar_d.getTime());
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g == null) {
            g = this.getGraphics();
        }
        int width = this.getSize().width;
        g.setColor(UIManager.getColor("control"));
        Border border = this.getBorder();
        Insets insets = border.getBorderInsets(this);
        g.fillRect(insets.left, insets.top, this.getSize().width - (insets.left + insets.right), this.getSize().height - (insets.top + insets.bottom));
        g.setColor(Color.black);
        g.setFont(this.fontBold_d);
        FontMetrics fontmetrics = g.getFontMetrics();
        String label = this.monthLabel_d.format(this.calendar_d.getTime());
        g.drawString(label, width / 2 - fontmetrics.stringWidth(label) / 2, 17 + insets.top);
        g.setFont(this.fontPlain_d);
        int leftMargin = insets.left + 5;
        int topMargin = insets.top + 36;
        int x = leftMargin;
        String[] dayNames = this.dateFormatSymbols_d.getShortWeekdays();
        fontmetrics = g.getFontMetrics();
        for (int i = 1; i < dayNames.length; ++i) {
            int w = fontmetrics.stringWidth(dayNames[i]);
            g.drawString(dayNames[i], x + this.halfXWidth_d - w / 2, topMargin);
            x += this.xWidth_d;
        }
        g.setColor(Color.gray);
        g.fillRect(leftMargin, topMargin + 4, x - 5, 3);
        Time original = this.timeField_d.getTime();
        int calendarMonth = this.calendar_d.get(2);
        GregorianCalendar gc = (GregorianCalendar)this.calendar_d.clone();
        gc.set(5, 1);
        g.setColor(Color.black);
        int row = 0;
        int day = 1;
        int month = calendarMonth;
        int year = gc.get(1);
        int weekDay = gc.get(7) - 1;
        while (month == calendarMonth) {
            this.valid_d[row][weekDay] = day;
            if (original != null && day == original.getDayOfMonth() && month + 1 == original.getMonth() && year == original.getYear()) {
                g.setColor(Color.blue);
            } else if (day == this.today_d.getDay() && month + 1 == this.today_d.getMonth() && year == this.today_d.getYear()) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            String dayStr = String.valueOf(day);
            g.drawString(dayStr, weekDay * this.xWidth_d + 10 + this.halfXWidth_d - fontmetrics.stringWidth(dayStr) + insets.left, 54 + insets.top + 12 * row);
            gc.add(5, 1);
            month = gc.get(2);
            day = gc.get(5);
            weekDay = gc.get(7) - 1;
            if (weekDay != 0) continue;
            ++row;
        }
        g.setFont(this.fontBold_d);
        g.setColor(Color.red);
        String today = CoreMsg.TODAY.getString(this.timeField_d.getLocale()) + ": ";
        g.drawString(today, 5 + insets.left, this.getSize().height - 8 - insets.bottom);
        g.setColor(Color.black);
        g.drawString(this.timeField_d.getFormat().format(this.today_d.dateValue()), 5 + g.getFontMetrics().stringWidth(today) + insets.left, this.getSize().height - 8 - insets.bottom);
    }

    @Override
    public void valueChanged(ValueChangedEvent event) {
        if (event.getValue() != null && event.getValue() != "") {
            Time time = (Time)event.getValue();
            this.calendar_d.set(11, time.getHourOfDay());
            this.calendar_d.set(12, time.getMinute());
            this.calendar_d.set(13, time.getSecond());
            this.timeField_d.setJavaDate(this.calendar_d.getTime());
        }
    }

    private void initialize() {
        this.incrementMonth = new BasicArrowButton(3);
        this.incrementMonth.setSize(new Dimension(20, 15));
        this.incrementMonth.addActionListener(this);
        this.decrementMonth = new BasicArrowButton(7);
        this.decrementMonth.setSize(new Dimension(20, 15));
        this.decrementMonth.addActionListener(this);
        this.incrementYear = new BasicArrowButton(1);
        this.incrementYear.setSize(new Dimension(15, 8));
        this.incrementYear.addActionListener(this);
        this.decrementYear = new BasicArrowButton(5);
        this.decrementYear.setSize(15, 8);
        this.decrementYear.addActionListener(this);
        Border border = this.getBorder();
        Insets insets = border.getBorderInsets(this);
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.add(this.decrementMonth);
        this.decrementMonth.setBounds(5 + insets.left, 5 + insets.top, 20, 15);
        this.add(this.incrementMonth);
        this.incrementMonth.setBounds(width - 5 - 20 - insets.right, 5 + insets.top, 20, 15);
        this.add(this.incrementYear);
        this.incrementYear.setBounds(width / 2 + 65 - insets.right, 5 + insets.top, 15, 8);
        this.add(this.decrementYear);
        this.decrementYear.setBounds(width / 2 + 65 - insets.right, 13 + insets.top, 15, 8);
        if (this.timeSpinner_d != null) {
            this.add(this.timeSpinner_d);
            this.timeSpinner_d.setBounds(5 + insets.left, height - 50, width - 10 - insets.left - insets.right, 23);
        }
    }
}

