/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bpm.log.Log;
import oracle.bpm.ui.tree.TreeNode;

class SwingTreeModel
implements TreeModel {
    private TreeModelListener broadcaster;
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private TreeNode rootNode;

    SwingTreeModel() {
    }

    @Override
    public Object getRoot() {
        return this.getRootTreeNode();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof TreeNode) {
            return ((TreeNode)node).isLeaf();
        }
        System.out.println("SwingTree$SwingTreeModelAdapter.isLeaf " + node + node.getClass());
        return false;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        TreeNode aNode = (TreeNode)path.getLastPathComponent();
        aNode.setUserObject(newValue);
        this.nodeChanged(aNode);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void setRootTreeNode(TreeNode rootNode) {
        this.rootNode = rootNode;
    }

    public void nodeChanged(TreeNode node) {
        if (this.listeners != null && node != null) {
            TreeNode parent = node.getParent();
            if (parent == null) {
                if (node == this.getRoot()) {
                    TreeModelEvent e = new TreeModelEvent((Object)this, node.getPath(), null, null);
                    this.getBroadcaster().treeNodesChanged(e);
                }
            } else {
                int index = parent.getIndex(node);
                if (index != -1) {
                    int[] childIndices = new int[]{index};
                    Object[] children = new Object[]{node};
                    TreeModelEvent e = new TreeModelEvent((Object)this, parent.getPath(), childIndices, children);
                    this.getBroadcaster().treeNodesChanged(e);
                }
            }
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        if (node != null) {
            TreeModelEvent e = new TreeModelEvent((Object)this, node.getPath(), null, null);
            this.getBroadcaster().treeStructureChanged(e);
        }
    }

    public void insertNodeInto(TreeNode newChild, TreeNode parent, int index) {
        parent.insert(newChild, index);
        this.nodesWereInserted(parent, new int[]{index});
    }

    public void removeNodeFromParent(TreeNode node) {
        TreeNode parent = node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            TreeModelEvent e = new TreeModelEvent((Object)this, node.getPath(), childIndices, removedChildren);
            this.getBroadcaster().treeNodesRemoved(e);
        }
    }

    private TreeModelListener getBroadcaster() {
        if (this.broadcaster == null) {
            this.broadcaster = new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent event) {
                    for (TreeModelListener listener : SwingTreeModel.this.listeners) {
                        try {
                            listener.treeNodesChanged(event);
                        }
                        catch (Exception unexpected) {
                            Log.logSevere((Throwable)unexpected);
                        }
                    }
                }

                @Override
                public void treeNodesInserted(TreeModelEvent event) {
                    for (TreeModelListener listener : SwingTreeModel.this.listeners) {
                        try {
                            listener.treeNodesInserted(event);
                        }
                        catch (Exception unexpected) {
                            Log.logSevere((Throwable)unexpected);
                        }
                    }
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent event) {
                    for (TreeModelListener listener : SwingTreeModel.this.listeners) {
                        try {
                            listener.treeNodesRemoved(event);
                        }
                        catch (Exception unexpected) {
                            Log.logSevere((Throwable)unexpected);
                        }
                    }
                }

                @Override
                public void treeStructureChanged(TreeModelEvent event) {
                    for (TreeModelListener listener : SwingTreeModel.this.listeners) {
                        try {
                            listener.treeStructureChanged(event);
                        }
                        catch (Exception unexpected) {
                            Log.logSevere((Throwable)unexpected);
                        }
                    }
                }
            };
        }
        return this.broadcaster;
    }

    private void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.listeners != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            TreeModelEvent e = new TreeModelEvent((Object)this, node.getPath(), childIndices, newChildren);
            this.getBroadcaster().treeNodesInserted(e);
        }
    }

    private TreeNode getRootTreeNode() {
        return this.rootNode;
    }
}

