/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import foxtrot.Job;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.log.Log;
import oracle.bpm.ui.FuegoJob;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.peer.ToolkitPeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.SwingFontMetrics;

public class SwingToolkit
implements ToolkitPeer {
    private JLabel label = new JLabel();

    @Override
    public Font getDefaultFont() {
        return Font.valueOf(this.label.getFont());
    }

    @Override
    public SwingFontMetrics getFontMetrics(Font font) {
        FontMetrics metrics = this.label.getFontMetrics(AwtConverter.toAwt(font));
        return new SwingFontMetrics(metrics);
    }

    @Override
    public int getScreenResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    @Override
    public Dimension getScreenSize() {
        return AwtConverter.fromAwt(Toolkit.getDefaultToolkit().getScreenSize());
    }

    @Override
    public <T> T post(FuegoJob<T> job) {
        return (T)Worker.post((Job)new MyJob(job));
    }

    @Override
    public void post(Runnable runnable) {
        Worker.post((Job)new JobFromRunnable(runnable));
    }

    @Override
    public boolean post(FuegoWorker.BooleanJob fuegoBooleanJob) {
        return (Boolean)Worker.post((Job)new JobFromBooleanJob(fuegoBooleanJob));
    }

    @Override
    public <T> T post(FuegoWorker.Task<T> runnable) throws Exception {
        return (T)Worker.post((Task)new MyTask(runnable));
    }

    @Override
    public void post(FuegoWorker.Procedure procedure) throws Exception {
        Worker.post((Task)new TaskFromProcedure(procedure));
    }

    @Override
    public boolean post(FuegoWorker.BooleanTask fuegoBooleanTask) throws Exception {
        return (Boolean)Worker.post((Task)new TaskFromBooleanTask(fuegoBooleanTask));
    }

    @Override
    public void invokeAndWait(Runnable runnable) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException e) {
            Log.logWarning((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)new RuntimeException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public boolean isEventDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    @Override
    public void invokeLater(Runnable runnable, boolean force) {
        if (SwingUtilities.isEventDispatchThread() && !force) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void invokeLater(Runnable runnable) {
        this.invokeLater(runnable, false);
    }

    @Override
    public void paintComponent(Graphics g, UiComponent c, UiComponent p, Rectangle bounds) {
        SwingUtilities.paintComponent(AwtConverter.toAwt(g), c.asSwing(), p.asSwing(), AwtConverter.toAwt(bounds));
    }

    private static class TaskFromProcedure
    extends Task {
        private final FuegoWorker.Procedure procedure;

        public TaskFromProcedure(FuegoWorker.Procedure procedure) {
            this.procedure = procedure;
        }

        public Object run() throws Exception {
            this.procedure.run();
            return null;
        }
    }

    private static class TaskFromBooleanTask
    extends Task {
        private final FuegoWorker.BooleanTask booleanTask;

        public TaskFromBooleanTask(FuegoWorker.BooleanTask fuegoBooleanTask) {
            this.booleanTask = fuegoBooleanTask;
        }

        public Object run() throws Exception {
            return this.booleanTask.run();
        }
    }

    private static class MyTask
    extends Task {
        private final FuegoWorker.Task runnable;

        public MyTask(FuegoWorker.Task runnable) {
            this.runnable = runnable;
        }

        public Object run() throws Exception {
            return this.runnable.run();
        }
    }

    private static class MyJob
    extends Job {
        private final FuegoJob runnable;

        public MyJob(FuegoJob runnable) {
            this.runnable = runnable;
        }

        public Object run() {
            return this.runnable.run();
        }
    }

    private static class JobFromRunnable
    extends Job {
        private final Runnable runnable;

        public JobFromRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        public Object run() {
            this.runnable.run();
            return null;
        }
    }

    private static class JobFromBooleanJob
    extends Job {
        private final FuegoWorker.BooleanJob booleanJob;

        public JobFromBooleanJob(FuegoWorker.BooleanJob fuegoBooleanJob) {
            this.booleanJob = fuegoBooleanJob;
        }

        public Object run() {
            return this.booleanJob.run();
        }
    }
}

