/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.SVGImage;
import oracle.bpm.ui.peer.SVGImagePeer;
import oracle.bpm.ui.peer.swing.SwingGraphics;
import oracle.bpm.ui.peer.swing.SwingImagePeer;
import oracle.bpm.ui.peer.swing.svg.FilteredGraphics;
import oracle.bpm.ui.utils.ImageExtension;
import oracle.bpm.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SwingSVGImage
extends SwingImagePeer
implements SVGImagePeer {
    private GraphicsNode cache;
    private float height;
    private TranscodingHints hints;
    private ImageTranscoder imageTranscoder;
    private BufferedImage img;
    private TranscoderInput input;
    private float lastGeneratedHeigth;
    private float lastGeneratedWidth;
    private BufferedImage lastImage;
    private int lastScaledHeight;
    private int lastScaledWidth;
    private SVGImage lastSVG;
    private String uri;
    private URL url;
    private float width;

    public SwingSVGImage(URL url) throws IOException {
        String uri;
        this.url = url;
        try {
            uri = url.toURI().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.uri = uri;
        this.input = new TranscoderInput(uri);
        this.hints = new TranscodingHints();
        this.setWidth(70.0f);
        this.setHeigth(50.0f);
        this.tryReadAhead();
    }

    @Override
    public Graphics getGraphics() {
        return null;
    }

    @Override
    public int getHeight() {
        return (int)this.height;
    }

    @Override
    public int getIconHeight() {
        return (int)this.height;
    }

    @Override
    public int getIconWidth() {
        return (int)this.width;
    }

    @Override
    public Object getNative() {
        return new ImageIcon(this.asAwtImage());
    }

    @Override
    public SVGImage getScaledInstance(int width, int height, int hints) {
        if (this.lastSVG == null || this.lastScaledWidth != width || this.lastScaledHeight != height) {
            this.lastScaledWidth = width;
            this.lastScaledHeight = height;
            SwingSVGImage scaled = null;
            try {
                scaled = new SwingSVGImage(this.url);
            }
            catch (IOException e) {
                // empty catch block
            }
            scaled.setWidth(width);
            scaled.setHeigth(height);
            this.lastSVG = SVGImage.create(scaled);
        }
        return this.lastSVG;
    }

    @Override
    public int getWidth() {
        return (int)this.width;
    }

    @Override
    public void flush() {
    }

    @Override
    public Image rotate90cc() {
        return null;
    }

    @Override
    public Image getGrayed() {
        return null;
    }

    @Override
    public int[] handlePixels() {
        int width = this.getWidth();
        int height = this.getHeight();
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(this.asAwtImage(), 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("interrupted waiting for pixels!");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new IllegalStateException("image fetch aborted or errored");
        }
        return pixels;
    }

    @Override
    public void write(File file, ImageExtension fileExtension) {
    }

    @Override
    public void write(OutputStream os, ImageExtension extension) {
    }

    @Override
    public java.awt.Image asAwtImage() {
        if (this.lastImage == null || this.width != this.lastGeneratedWidth || this.height != this.lastGeneratedHeigth) {
            try {
                this.lastImage = this.createBufferedImage();
                this.lastGeneratedHeigth = this.height;
                this.lastGeneratedWidth = this.width;
            }
            catch (TranscoderException e) {
                this.lastImage = null;
            }
        }
        return this.lastImage;
    }

    public ImageTranscoder getImageTranscoder() {
        if (this.imageTranscoder == null) {
            this.imageTranscoder = new ImageTranscoder(){
                private BufferedImage last;
                private int lastW;
                private int lastH;
                public TranscoderInput lastInput;

                public BufferedImage createImage(int w, int h) {
                    if (this.last == null || w != this.lastW || h != this.lastH) {
                        this.last = new BufferedImage(w, h, 2){

                            @Override
                            public java.awt.Image getScaledInstance(int width, int height, int hints) {
                                return super.getScaledInstance(width, height, hints);
                            }
                        };
                        this.lastW = w;
                        this.lastH = h;
                    }
                    return this.last;
                }

                protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
                    if (this.lastInput != null && this.lastInput.getURI().equals(uri)) {
                        this.lastInput.setDocument(document);
                    }
                    super.transcode(document, uri, output);
                }

                public void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
                    this.lastInput = input;
                    super.transcode(input, output);
                }

                public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
                    SwingSVGImage.this.setImage(img);
                }
            };
        }
        return this.imageTranscoder;
    }

    @Override
    public boolean drawImage(java.awt.Graphics g, int x, int y, ImageObserver o) {
        return g.drawImage(this.asAwtImage(), x, y, o);
    }

    public boolean isVisible(int x, int y, Rectangle bounds) {
        Point point = new Point(x, y);
        Point2D scaledPoint = this.scalePoint(point, bounds);
        return this.getSvgIcon().nodeHitAt(scaledPoint) != null;
    }

    public boolean isInside(oracle.bpm.geom.Point point, Rectangle bounds) {
        Point2D scaledPoint = this.scalePoint(point.toPoint2D(), bounds);
        return this.getSvgIcon().contains(scaledPoint);
    }

    @Override
    public boolean drawImage(java.awt.Graphics g, int x, int y, int width, int height, ImageObserver o) {
        boolean result;
        if (g instanceof Graphics2D) {
            GraphicsNode svgIcon = this.getSvgIcon();
            Rectangle2D rect = svgIcon.getBounds();
            double scaleX = (double)width / rect.getWidth();
            double scaleY = (double)height / rect.getHeight();
            SwingSVGImage.paintSvgIcon((Graphics2D)g, svgIcon, x, y, scaleX, scaleY);
            result = true;
        } else {
            result = g.drawImage(this.asAwtImage(), x, y, width, height, o);
        }
        return result;
    }

    @Override
    public boolean drawImage(java.awt.Graphics g, int x, int y, Color bgcolor, JComponent observer) {
        return g.drawImage(this.asAwtImage(), x, y, bgcolor, observer);
    }

    private static boolean contains(GraphicsNode node, Point2D p, AffineTransform transform) {
        Rectangle2D bounds = node.getTransformedSensitiveBounds(transform);
        if (node instanceof CompositeGraphicsNode) {
            CompositeGraphicsNode comp = (CompositeGraphicsNode)node;
            List childs = comp.getChildren();
            if (childs.size() > 0 && bounds != null && bounds.contains(p)) {
                for (Object child : childs) {
                    GraphicsNode each = (GraphicsNode)child;
                    if (!SwingSVGImage.contains(each, p, transform)) continue;
                    return true;
                }
            }
        } else {
            Rectangle2D b = node.getTransformedSensitiveBounds(transform);
            if (b != null && b.contains(p)) {
                return true;
            }
        }
        return false;
    }

    private static GraphicsNode getSvgIcon(URL url) {
        GraphicsNode svgIcon = null;
        try {
            String xmlParser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(xmlParser);
            SVGDocument doc = df.createSVGDocument(url.toString());
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            ctx.setDynamicState(2);
            GVTBuilder builder = new GVTBuilder();
            svgIcon = builder.build(ctx, (Document)doc);
        }
        catch (Exception excp) {
            svgIcon = null;
            excp.printStackTrace();
        }
        return svgIcon;
    }

    private static void paintSvgIcon(Graphics2D g, GraphicsNode svgIcon, int x, int y, double scaleX, double scaleY) {
        AffineTransform transform = new AffineTransform(scaleX, 0.0, 0.0, scaleY, (double)x, (double)y);
        svgIcon.setTransform(transform);
        if (Boolean.TRUE == g.getRenderingHint(SwingGraphics.useFilter)) {
            FilteredGraphics transformed = FilteredGraphics.transform(g);
            svgIcon.paint((Graphics2D)transformed);
        } else {
            svgIcon.paint(g);
        }
        svgIcon.setTransform(new AffineTransform());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryReadAhead() {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(this.url.openStream()));
            char[] buffer = new char[1000];
            in.read(buffer);
            String bufferString = new String(buffer);
            String viewBoxText = "viewBox=\"";
            int start = bufferString.indexOf(viewBoxText);
            if (start > 0) {
                int end = bufferString.indexOf("\"", start + viewBoxText.length() + 1);
                String viewBox = bufferString.substring(start, end);
                StringTokenizer tokenizer = new StringTokenizer(viewBox, " ");
                if (tokenizer.hasMoreTokens()) {
                    tokenizer.nextToken();
                }
                if (tokenizer.hasMoreTokens()) {
                    tokenizer.nextToken();
                }
                if (tokenizer.hasMoreTokens()) {
                    String widthString = tokenizer.nextToken();
                    this.setWidth((float)Double.parseDouble(widthString));
                }
                if (tokenizer.hasMoreTokens()) {
                    String heightString = tokenizer.nextToken();
                    this.setHeigth((float)Double.parseDouble(heightString));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private BufferedImage createBufferedImage() throws TranscoderException {
        ImageTranscoder imageTranscoder = this.getImageTranscoder();
        imageTranscoder.setTranscodingHints((Map)this.hints);
        imageTranscoder.transcode(this.input, null);
        return this.img;
    }

    private void setImage(BufferedImage img) {
        this.img = img;
    }

    private void setWidth(float width) {
        this.width = width;
        this.hints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
    }

    private void setHeigth(float height) {
        this.height = height;
        this.hints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
    }

    private Point2D scalePoint(Point2D point, Rectangle bounds) {
        GraphicsNode svgIcon = this.getSvgIcon();
        Rectangle2D rect = svgIcon.getBounds();
        double scaleX = rect.getWidth() / (double)bounds.getWidth();
        double scaleY = rect.getHeight() / (double)bounds.getHeight();
        Point2D.Double p = new Point2D.Double(point.getX() * scaleX, point.getY() * scaleY);
        return p;
    }

    private GraphicsNode getSvgIcon() {
        if (this.cache == null) {
            URL url = null;
            try {
                url = new URL(this.uri);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            this.cache = SwingSVGImage.getSvgIcon(url);
        }
        return this.cache;
    }
}

