/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.peer.ListPeer;
import oracle.bpm.ui.peer.swing.SwingCellRenderer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;
import oracle.bpm.ui.peer.swing.dnd.SwingDraggableComponent;
import oracle.bpm.ui.peer.swing.event.SwingListSelectionListener;

class SwingList
extends SwingContainer
implements ListPeer,
SwingDraggableComponent {
    private JList list;
    private SwingCellRenderer renderer;

    public SwingList(SwingComponent parent, ListSelectionMode listSelectionMode) {
        super(parent, new JList());
        this.list = (JList)this.getJComponent();
        this.setSelectionMode(listSelectionMode);
    }

    public SwingList(SwingComponent parent, ListSelectionMode listSelectionMode, ScrollPolicy vertical, ScrollPolicy horizontal) {
        super(parent, new JScrollPane());
        JScrollPane scrollPane = (JScrollPane)this.getJComponent();
        JList list = new JList();
        scrollPane.setViewportView(list);
        this.list = list;
        this.setSelectionMode(listSelectionMode);
    }

    @Override
    public List<UiComponent> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void setColorProvider(ColorProvider provider) {
        this.getSwingRenderer().setColorProvider(provider);
    }

    @Override
    public void setFontProvider(FontProvider provider) {
        this.getSwingRenderer().setFontProvider(provider);
    }

    @Override
    public void setLabelProvider(LabelProvider provider) {
        this.getSwingRenderer().setLabelProvider(provider);
    }

    @Override
    public void setModel(ListModel model) {
        this.getList().setModel(model);
    }

    @Override
    public ListModel getModel() {
        return this.getList().getModel();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.getList().setSelectedIndex(index);
    }

    @Override
    public int getSelectedIndex() {
        return this.getList().getSelectedIndex();
    }

    @Override
    public void setSelectedIndices(int[] indexes) {
        this.getList().setSelectedIndices(indexes);
    }

    @Override
    public int[] getSelectedIndices() {
        return this.getList().getSelectedIndices();
    }

    @Override
    public void setSelectedValue(Object value, boolean shouldScroll) {
        this.getList().setSelectedValue(value, shouldScroll);
    }

    @Override
    public Object getSelectedValue() {
        return this.getList().getSelectedValue();
    }

    @Override
    public Object[] getSelectedValues() {
        return this.getList().getSelectedValues();
    }

    @Override
    public void setSelectionInterval(int start, int end) {
        this.getList().setSelectionInterval(start, end);
    }

    @Override
    public void setVisibleRowCount(int visibleRowCount) {
        this.getList().setVisibleRowCount(visibleRowCount);
    }

    @Override
    public int getVisibleRowCount() {
        return this.getList().getVisibleRowCount();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.getList().addListSelectionListener(SwingListSelectionListener.get(listener));
    }

    @Override
    public void clearSelection() {
        this.getList().clearSelection();
    }

    @Override
    public void ensureIndexIsVisible(int index) {
        this.getList().ensureIndexIsVisible(index);
    }

    @Override
    public int locationToIndex(Point point) {
        return this.getList().locationToIndex(SwingList.asSwingPoint(point));
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        this.getList().removeListSelectionListener(SwingListSelectionListener.get(listener));
    }

    @Override
    public Component getInputTarget() {
        return this.getList();
    }

    @Override
    public void setDragEnabled(boolean enabled) {
        this.getList().setDragEnabled(enabled);
    }

    @Override
    public boolean getDragEnabled() {
        return this.getList().getDragEnabled();
    }

    protected SwingCellRenderer getSwingRenderer() {
        if (this.renderer == null) {
            this.renderer = new SwingCellRenderer();
            this.getList().setCellRenderer(this.renderer);
        }
        return this.renderer;
    }

    private void setSelectionMode(ListSelectionMode mode) {
        if (mode == ListSelectionMode.SINGLE_SELECTION) {
            this.getList().setSelectionMode(0);
        } else if (mode == ListSelectionMode.SINGLE_INTERVAL_SELECTION) {
            this.getList().setSelectionMode(1);
        } else {
            assert (mode == ListSelectionMode.MULTIPLE_INTERVAL_SELECTION) : mode;
            this.getList().setSelectionMode(2);
        }
    }

    private JList getList() {
        return this.list;
    }
}

