/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Gallery;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.peer.GalleryPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;
import oracle.bpm.ui.peer.swing.event.SwingListSelectionListener;
import oracle.bpm.ui.peer.swing.event.SwingMouseListener;
import org.jetbrains.annotations.NotNull;

public class SwingGallery<T extends Gallery.GalleryElement>
extends SwingContainer
implements GalleryPeer<T> {
    private Gallery<T> gallery;

    public SwingGallery(SwingComponent parent, Msg title, List<T> elements) {
        super(parent);
        this.gallery = new Gallery<T>(title, elements);
        this.setComponent(this.gallery);
    }

    @Override
    public T getSelection() {
        return this.gallery.getSelection();
    }

    @Override
    public void setSelection(T selection) {
        this.gallery.setSelection(selection);
    }

    @Override
    public void addListSelectionListener(@NotNull ListSelectionListener listener) {
        this.gallery.addListSelectionListener(listener);
    }

    @Override
    public void removeListSelectionListener(@NotNull ListSelectionListener listener) {
        this.gallery.removeListSelectionListener(listener);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.gallery.addMouseListener(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.gallery.addMouseListener(listener);
    }

    private static final class GalleryTableModel<T extends Gallery.GalleryElement>
    extends AbstractTableModel {
        final List<T> elements = new ArrayList<T>();
        private static final long serialVersionUID = 0L;

        public GalleryTableModel(List<T> list) {
            this.elements.addAll(list);
        }

        public Class getColumnClass(int columnIndex) {
            return Gallery.GalleryElement.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.elements.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= 0 && row < this.elements.size()) {
                return this.elements.get(row);
            }
            return null;
        }

        public T getElementAt(int selectedRow) {
            return (T)((Gallery.GalleryElement)this.elements.get(selectedRow));
        }

        public int indexOf(Gallery.GalleryElement selection) {
            return this.elements.indexOf(selection);
        }
    }

    private static class GalleryTable<T extends Gallery.GalleryElement>
    extends JTable {
        private static final long serialVersionUID = 0L;

        public GalleryTable(List<T> elements) {
            super(new GalleryTableModel<T>(elements));
            this.setName("ItemsList");
            this.setBorder(null);
            this.setShowGrid(false);
            this.setAutoscrolls(true);
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setTableHeader(null);
            this.setColumnSelectionAllowed(false);
            this.setSelectionMode(0);
            this.setDefaultRenderer(Gallery.GalleryElement.class, new ItemTableCellRenderer());
            Dimension pref = this.getPreferredScrollableViewportSize();
            this.setPreferredScrollableViewportSize(new Dimension(pref.width, this.getRowHeight() * 10));
        }

        public T getSelection() {
            int selectedRow = this.getSelectedRow();
            if (selectedRow < 0 || !(this.getModel() instanceof GalleryTableModel)) {
                return null;
            }
            return ((GalleryTableModel)this.getModel()).getElementAt(this.getSelectedRow());
        }

        public void setSelection(T selection) {
            int index0 = ((GalleryTableModel)this.getModel()).indexOf((Gallery.GalleryElement)selection);
            this.getSelectionModel().setSelectionInterval(index0, index0);
        }
    }

    private static class Gallery<T extends Gallery.GalleryElement>
    extends JPanel {
        private GalleryTable<T> galleryTable;
        private static final long serialVersionUID = 0L;

        public Gallery(Msg title, List<T> elements) {
            this.setLayout(new BorderLayout());
            this.setBorder(null);
            this.setOpaque(true);
            this.setBackground(SystemColor.WHITE);
            String text = CoreMsg.COLON((String)title.getString()).getString();
            JLabel titleLabel = new JLabel(text);
            JPanel itemsListHeaderPanel = new JPanel();
            itemsListHeaderPanel.setLayout(new GridBagLayout());
            itemsListHeaderPanel.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)itemsListHeaderPanel, "North");
            this.galleryTable = new GalleryTable<T>(elements);
            JScrollPane scrollPane = new JScrollPane(20, 31);
            scrollPane.setViewportView(this.galleryTable);
            scrollPane.setName("JSPItemsList");
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            scrollPane.getViewport().setBackground(Color.WHITE);
            this.add((Component)scrollPane, "Center");
        }

        public T getSelection() {
            return this.galleryTable.getSelection();
        }

        public void setSelection(T selection) {
            this.galleryTable.setSelection(selection);
        }

        public void addListSelectionListener(@NotNull ListSelectionListener listener) {
            SwingListSelectionListener swingListSelectionListener = SwingListSelectionListener.get(listener);
            this.galleryTable.getSelectionModel().addListSelectionListener(swingListSelectionListener);
        }

        public void removeListSelectionListener(@NotNull ListSelectionListener listener) {
            SwingListSelectionListener swingListSelectionListener = SwingListSelectionListener.get(listener);
            this.galleryTable.getSelectionModel().addListSelectionListener(swingListSelectionListener);
        }

        public void addMouseListener(@NotNull MouseListener listener) {
            SwingMouseListener swingMouseListener = SwingMouseListener.get(listener);
            this.galleryTable.addMouseListener(swingMouseListener);
        }

        public void removeMouseListener(@NotNull MouseListener listener) {
            SwingMouseListener swingMouseListener = SwingMouseListener.get(listener);
            this.galleryTable.removeMouseListener(swingMouseListener);
        }
    }

    public static final class ItemTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private GridBagConstraints _constraints = new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 5, 0);
        private final Color bandingBackgroundColor = new Color(250, 250, 250);
        private final Border bottomOnlyBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(204, 204, 204)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        private final JTextArea description = new JTextArea();
        private final Border descriptionBorder = BorderFactory.createEmptyBorder(0, 20, 0, 5);
        private JPanel descriptionPanel;
        private final JLabel header = new JLabel();
        private final JLabel headerDetail = new JLabel();
        private final JLabel iconLabel = new JLabel();
        private JPanel panel;
        private final Color selectionHighlightColor = new Color(216, 236, 253);
        private static final long serialVersionUID = 0L;

        public ItemTableCellRenderer() {
            super(new GridBagLayout());
            this.setBorder(this.bottomOnlyBorder);
            this.description.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.description.setFont(this.header.getFont());
            this.description.setEditable(false);
            this.description.setOpaque(false);
            this.description.setLineWrap(true);
            this.description.setWrapStyleWord(true);
            this.iconLabel.setOpaque(true);
            this.iconLabel.setBackground(Color.WHITE);
            this.iconLabel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.descriptionPanel = new JPanel(new GridBagLayout());
            this.descriptionPanel.setOpaque(false);
            this.descriptionPanel.setBackground(Color.BLUE);
            this.panel = new JPanel();
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.descriptionPanel.add((Component)this.description, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.descriptionPanel.add((Component)this.iconLabel, new GridBagConstraints(0, 2, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.descriptionPanel.setBorder(this.descriptionBorder);
            this.add((Component)this.header, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 5, 0));
            this.headerDetail.setOpaque(false);
            this.add((Component)this.headerDetail, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 5), 5, 0));
            this.add((Component)this.descriptionPanel, this._constraints);
            this.add((Component)Box.createHorizontalBox(), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Gallery.GalleryElement) {
                Gallery.GalleryElement element = (Gallery.GalleryElement)value;
                Icon enabledIcon = this.getIcon(element.getIcon());
                Icon disabledIcon = this.getIcon(element.getDisabledIcon());
                this.header.setIcon(enabledIcon);
                this.header.setDisabledIcon(disabledIcon);
                this.header.setText(element.getShortLabel().toString());
                this.header.setFont(this.header.getFont().deriveFont(isSelected ? 1 : 0));
                boolean enabled = element.isAvailable() && table.isEnabled();
                this.header.setEnabled(enabled);
                String details = element.getDescriptionMsg().getDetail();
                this.description.setText(details);
                UiComponent content = element.getContent(null);
                if (content != null) {
                    this.panel.removeAll();
                    this.panel.add((Component)content.asSwing(), "Center");
                }
                this.iconLabel.setIcon(this.getIcon(element.getDescriptionIcon()));
                if (isSelected) {
                    this.description.setEnabled(enabled);
                    this.add((Component)this.descriptionPanel, this._constraints);
                } else {
                    this.description.setText("");
                    this.remove(this.descriptionPanel);
                    this.revalidate();
                }
                this.colorControls(row, enabled, isSelected);
                int prefHeight = this.getPreferredSize().height;
                if (prefHeight != table.getRowHeight(row)) {
                    int adjustedHeight = Math.min(prefHeight, 180);
                    table.setRowHeight(row, adjustedHeight);
                }
            }
            return this;
        }

        public String getText() {
            return this.header.getText() + " " + this.description.getText();
        }

        private Icon getIcon(Msg icon) {
            Image uiIcon = Image.create(icon);
            return uiIcon == null ? null : uiIcon.asSwingIcon();
        }

        private void colorControls(int row, boolean isEnabled, boolean isSelected) {
            Color bgcolor = row % 2 == 0 ? SystemColor.WHITE : this.bandingBackgroundColor;
            this.setBackground(isSelected ? this.selectionHighlightColor : bgcolor);
        }
    }
}

